<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentList DTO
 * @subpackage Structs
 */
class DocumentList extends AbstractStructBase
{
    /**
     * The document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\DocumentInfo[]
     */
    public $document;
    /**
     * Constructor method for DocumentList
     * @uses DocumentList::setDocument()
     * @param \App\Integration\Providers\Alliance3\DTO\DocumentInfo[] $document
     */
    public function __construct(array $document = array())
    {
        $this
            ->setDocument($document);
    }
    /**
     * Get document value
     * @return \App\Integration\Providers\Alliance3\DTO\DocumentInfo[]|null
     */
    public function getDocument()
    {
        return $this->document;
    }
    /**
     * Set document value
     * @param \App\Integration\Providers\Alliance3\DTO\DocumentInfo[] $document
     * @return \App\Integration\Providers\Alliance3\DTO\DocumentList
     */
    public function setDocument(array $document = array())
    {
        $this->document = $document;
        return $this;
    }
    /**
     * Add item to document value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\DocumentInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\DocumentList
     */
    public function addToDocument(\App\Integration\Providers\Alliance3\DTO\DocumentInfo $item)
    {
        $this->document[] = $item;
        return $this;
    }
}
