<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryList DTO
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryList
 * @subpackage Structs
 */
class DictionaryList extends AbstractStructBase
{
    /**
     * The Types
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\DictionaryTypeList
     */
    public $Types;
    /**
     * The Dictionary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Dictionary
     * @var \App\Integration\Providers\Alliance3\DTO\Dictionary[]
     */
    public $Dictionary;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ErrorList
     */
    public $Errors;
    /**
     * Constructor method for DictionaryList
     * @uses DictionaryList::setTypes()
     * @uses DictionaryList::setDictionary()
     * @uses DictionaryList::setErrors()
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryTypeList $types
     * @param \App\Integration\Providers\Alliance3\DTO\Dictionary[] $dictionary
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     */
    public function __construct(\App\Integration\Providers\Alliance3\DTO\DictionaryTypeList $types = null, array $dictionary = array(), \App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null)
    {
        $this
            ->setTypes($types)
            ->setDictionary($dictionary)
            ->setErrors($errors);
    }
    /**
     * Get Types value
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryTypeList|null
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryTypeList $types
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryList
     */
    public function setTypes(\App\Integration\Providers\Alliance3\DTO\DictionaryTypeList $types = null)
    {
        $this->Types = $types;
        return $this;
    }
    /**
     * Get Dictionary value
     * @return \App\Integration\Providers\Alliance3\DTO\Dictionary[]|null
     */
    public function getDictionary()
    {
        return $this->Dictionary;
    }
    /**
     * Set Dictionary value
     * @param \App\Integration\Providers\Alliance3\DTO\Dictionary[] $dictionary
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryList
     */
    public function setDictionary(array $dictionary = array())
    {
        $this->Dictionary = $dictionary;
        return $this;
    }
    /**
     * Add item to Dictionary value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\Dictionary $item
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryList
     */
    public function addToDictionary(\App\Integration\Providers\Alliance3\DTO\Dictionary $item)
    {
        $this->Dictionary[] = $item;
        return $this;
    }
    /**
     * Get Errors value
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorList|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryList
     */
    public function setErrors(\App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
