<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryConstraint DTO
 * @subpackage Structs
 */
class DictionaryConstraint extends AbstractStructBase
{
    /**
     * The Constraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\Constraint[]
     */
    public $Constraint;
    /**
     * Constructor method for DictionaryConstraint
     * @uses DictionaryConstraint::setConstraint()
     * @param \App\Integration\Providers\Alliance3\DTO\Constraint[] $constraint
     */
    public function __construct(array $constraint = array())
    {
        $this
            ->setConstraint($constraint);
    }
    /**
     * Get Constraint value
     * @return \App\Integration\Providers\Alliance3\DTO\Constraint[]|null
     */
    public function getConstraint()
    {
        return $this->Constraint;
    }
    /**
     * Set Constraint value
     * @param \App\Integration\Providers\Alliance3\DTO\Constraint[] $constraint
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryConstraint
     */
    public function setConstraint(array $constraint = array())
    {
        $this->Constraint = $constraint;
        return $this;
    }
    /**
     * Add item to Constraint value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\Constraint $item
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryConstraint
     */
    public function addToConstraint(\App\Integration\Providers\Alliance3\DTO\Constraint $item)
    {
        $this->Constraint[] = $item;
        return $this;
    }
}
