<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryAttributeValueList DTO
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryAttributeValueList
 * @subpackage Structs
 */
class DictionaryAttributeValueList extends AbstractStructBase
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue[]
     */
    public $Items;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ErrorList
     */
    public $Errors;
    /**
     * Constructor method for DictionaryAttributeValueList
     * @uses DictionaryAttributeValueList::setItems()
     * @uses DictionaryAttributeValueList::setErrors()
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue[] $items
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     */
    public function __construct(array $items = array(), \App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null)
    {
        $this
            ->setItems($items)
            ->setErrors($errors);
    }
    /**
     * Get Items value
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue[]|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue[] $items
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValueList
     */
    public function setItems(array $items = array())
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Add item to Items value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue $item
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValueList
     */
    public function addToItems(\App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue $item)
    {
        $this->Items[] = $item;
        return $this;
    }
    /**
     * Get Errors value
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorList|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValueList
     */
    public function setErrors(\App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
