<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dictionary DTO
 * Meta information extracted from the WSDL
 * - type: tns:Dictionary
 * @subpackage Structs
 */
class Dictionary extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\DictionaryValue[]
     */
    public $Value;
    /**
     * Constructor method for Dictionary
     * @uses Dictionary::setCode()
     * @uses Dictionary::setValue()
     * @param string $code
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryValue[] $value
     */
    public function __construct($code = null, array $value = array())
    {
        $this
            ->setCode($code)
            ->setValue($value);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \App\Integration\Providers\Alliance3\DTO\Dictionary
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Value value
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryValue[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryValue[] $value
     * @return \App\Integration\Providers\Alliance3\DTO\Dictionary
     */
    public function setValue(array $value = array())
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\DictionaryValue $item
     * @return \App\Integration\Providers\Alliance3\DTO\Dictionary
     */
    public function addToValue(\App\Integration\Providers\Alliance3\DTO\DictionaryValue $item)
    {
        $this->Value[] = $item;
        return $this;
    }
}
