<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactPerson DTO
 * @subpackage Structs
 */
class ContactPerson extends AbstractStructBase
{
    /**
     * The person
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\PhysicalSubject
     */
    public $person;
    /**
     * The officialCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $officialCapacity;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * Constructor method for ContactPerson
     * @uses ContactPerson::setPerson()
     * @uses ContactPerson::setOfficialCapacity()
     * @uses ContactPerson::setNotes()
     * @param \App\Integration\Providers\Alliance3\DTO\PhysicalSubject $person
     * @param string $officialCapacity
     * @param string $notes
     */
    public function __construct(\App\Integration\Providers\Alliance3\DTO\PhysicalSubject $person = null, $officialCapacity = null, $notes = null)
    {
        $this
            ->setPerson($person)
            ->setOfficialCapacity($officialCapacity)
            ->setNotes($notes);
    }
    /**
     * Get person value
     * @return \App\Integration\Providers\Alliance3\DTO\PhysicalSubject|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param \App\Integration\Providers\Alliance3\DTO\PhysicalSubject $person
     * @return \App\Integration\Providers\Alliance3\DTO\ContactPerson
     */
    public function setPerson(\App\Integration\Providers\Alliance3\DTO\PhysicalSubject $person = null)
    {
        $this->person = $person;
        return $this;
    }
    /**
     * Get officialCapacity value
     * @return string|null
     */
    public function getOfficialCapacity()
    {
        return $this->officialCapacity;
    }
    /**
     * Set officialCapacity value
     * @param string $officialCapacity
     * @return \App\Integration\Providers\Alliance3\DTO\ContactPerson
     */
    public function setOfficialCapacity($officialCapacity = null)
    {
        $this->officialCapacity = $officialCapacity;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \App\Integration\Providers\Alliance3\DTO\ContactPerson
     */
    public function setNotes($notes = null)
    {
        $this->notes = $notes;
        return $this;
    }
}
