<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConstitutorListInfo DTO
 * @subpackage Structs
 */
class ConstitutorListInfo extends AbstractStructBase
{
    /**
     * The constitutors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\UchreditelInfo[]
     */
    public $constitutors;
    /**
     * Constructor method for ConstitutorListInfo
     * @uses ConstitutorListInfo::setConstitutors()
     * @param \App\Integration\Providers\Alliance3\DTO\UchreditelInfo[] $constitutors
     */
    public function __construct(array $constitutors = array())
    {
        $this
            ->setConstitutors($constitutors);
    }
    /**
     * Get constitutors value
     * @return \App\Integration\Providers\Alliance3\DTO\UchreditelInfo[]|null
     */
    public function getConstitutors()
    {
        return $this->constitutors;
    }
    /**
     * Set constitutors value
     * @param \App\Integration\Providers\Alliance3\DTO\UchreditelInfo[] $constitutors
     * @return \App\Integration\Providers\Alliance3\DTO\ConstitutorListInfo
     */
    public function setConstitutors(array $constitutors = array())
    {
        $this->constitutors = $constitutors;
        return $this;
    }
    /**
     * Add item to constitutors value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\UchreditelInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\ConstitutorListInfo
     */
    public function addToConstitutors(\App\Integration\Providers\Alliance3\DTO\UchreditelInfo $item)
    {
        $this->constitutors[] = $item;
        return $this;
    }
}
