<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalcPolicyResult DTO
 * @subpackage Structs
 */
class CalcPolicyResult extends AbstractStructBase
{
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\Policy
     */
    public $policy;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ErrorList
     */
    public $errors;
    /**
     * The paramDefaultValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ParamDefaultValuesList
     */
    public $paramDefaultValues;
    /**
     * The warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ErrorList
     */
    public $warnings;
    /**
     * Constructor method for CalcPolicyResult
     * @uses CalcPolicyResult::setUrl()
     * @uses CalcPolicyResult::setPolicy()
     * @uses CalcPolicyResult::setErrors()
     * @uses CalcPolicyResult::setParamDefaultValues()
     * @uses CalcPolicyResult::setWarnings()
     * @param string $url
     * @param \App\Integration\Providers\Alliance3\DTO\Policy $policy
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     * @param \App\Integration\Providers\Alliance3\DTO\ParamDefaultValuesList $paramDefaultValues
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $warnings
     */
    public function __construct($url = null, \App\Integration\Providers\Alliance3\DTO\Policy $policy = null, \App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null, \App\Integration\Providers\Alliance3\DTO\ParamDefaultValuesList $paramDefaultValues = null, \App\Integration\Providers\Alliance3\DTO\ErrorList $warnings = null)
    {
        $this
            ->setUrl($url)
            ->setPolicy($policy)
            ->setErrors($errors)
            ->setParamDefaultValues($paramDefaultValues)
            ->setWarnings($warnings);
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \App\Integration\Providers\Alliance3\DTO\CalcPolicyResult
     */
    public function setUrl($url = null)
    {
        $this->url = $url;
        return $this;
    }
    /**
     * Get policy value
     * @return \App\Integration\Providers\Alliance3\DTO\Policy|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @param \App\Integration\Providers\Alliance3\DTO\Policy $policy
     * @return \App\Integration\Providers\Alliance3\DTO\CalcPolicyResult
     */
    public function setPolicy(\App\Integration\Providers\Alliance3\DTO\Policy $policy = null)
    {
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get errors value
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     * @return \App\Integration\Providers\Alliance3\DTO\CalcPolicyResult
     */
    public function setErrors(\App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Get paramDefaultValues value
     * @return \App\Integration\Providers\Alliance3\DTO\ParamDefaultValuesList|null
     */
    public function getParamDefaultValues()
    {
        return $this->paramDefaultValues;
    }
    /**
     * Set paramDefaultValues value
     * @param \App\Integration\Providers\Alliance3\DTO\ParamDefaultValuesList $paramDefaultValues
     * @return \App\Integration\Providers\Alliance3\DTO\CalcPolicyResult
     */
    public function setParamDefaultValues(\App\Integration\Providers\Alliance3\DTO\ParamDefaultValuesList $paramDefaultValues = null)
    {
        $this->paramDefaultValues = $paramDefaultValues;
        return $this;
    }
    /**
     * Get warnings value
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorList|null
     */
    public function getWarnings()
    {
        return $this->warnings;
    }
    /**
     * Set warnings value
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $warnings
     * @return \App\Integration\Providers\Alliance3\DTO\CalcPolicyResult
     */
    public function setWarnings(\App\Integration\Providers\Alliance3\DTO\ErrorList $warnings = null)
    {
        $this->warnings = $warnings;
        return $this;
    }
}
