<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlankList DTO
 * @subpackage Structs
 */
class BlankList extends AbstractStructBase
{
    /**
     * The blanks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Integration\Providers\Alliance3\DTO\BlankEntry[]
     */
    public $blanks;
    /**
     * Constructor method for BlankList
     * @uses BlankList::setBlanks()
     * @param \App\Integration\Providers\Alliance3\DTO\BlankEntry[] $blanks
     */
    public function __construct(array $blanks = array())
    {
        $this
            ->setBlanks($blanks);
    }
    /**
     * Get blanks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Integration\Providers\Alliance3\DTO\BlankEntry[]|null
     */
    public function getBlanks()
    {
        return isset($this->blanks) ? $this->blanks : null;
    }
    /**
     * Set blanks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Integration\Providers\Alliance3\DTO\BlankEntry[] $blanks
     * @return \App\Integration\Providers\Alliance3\DTO\BlankList
     */
    public function setBlanks(array $blanks = array())
    {
        if (is_null($blanks) || (is_array($blanks) && empty($blanks))) {
            unset($this->blanks);
        } else {
            $this->blanks = $blanks;
        }
        return $this;
    }
    /**
     * Add item to blanks value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\BlankEntry $item
     * @return \App\Integration\Providers\Alliance3\DTO\BlankList
     */
    public function addToBlanks(\App\Integration\Providers\Alliance3\DTO\BlankEntry $item)
    {
        $this->blanks[] = $item;
        return $this;
    }
}
