<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Beneficiary DTO
 * @subpackage Structs
 */
class Beneficiary extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $number;
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo
     */
    public $subject;
    /**
     * The degreeOfRelation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $degreeOfRelation;
    /**
     * Constructor method for Beneficiary
     * @uses Beneficiary::setNumber()
     * @uses Beneficiary::setSubject()
     * @uses Beneficiary::setDegreeOfRelation()
     * @param int $number
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $subject
     * @param string $degreeOfRelation
     */
    public function __construct($number = null, \App\Integration\Providers\Alliance3\DTO\SubjectInfo $subject = null, $degreeOfRelation = null)
    {
        $this
            ->setNumber($number)
            ->setSubject($subject)
            ->setDegreeOfRelation($degreeOfRelation);
    }
    /**
     * Get number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \App\Integration\Providers\Alliance3\DTO\Beneficiary
     */
    public function setNumber($number = null)
    {
        $this->number = $number;
        return $this;
    }
    /**
     * Get subject value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $subject
     * @return \App\Integration\Providers\Alliance3\DTO\Beneficiary
     */
    public function setSubject(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $subject = null)
    {
        $this->subject = $subject;
        return $this;
    }
    /**
     * Get degreeOfRelation value
     * @return string|null
     */
    public function getDegreeOfRelation()
    {
        return $this->degreeOfRelation;
    }
    /**
     * Set degreeOfRelation value
     * @param string $degreeOfRelation
     * @return \App\Integration\Providers\Alliance3\DTO\Beneficiary
     */
    public function setDegreeOfRelation($degreeOfRelation = null)
    {
        $this->degreeOfRelation = $degreeOfRelation;
        return $this;
    }
}
