<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankRequisites DTO
 * @subpackage Structs
 */
class BankRequisites extends AbstractStructBase
{
    /**
     * The bank
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bank;
    /**
     * The bankBIK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankBIK;
    /**
     * The paymentAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentAccount;
    /**
     * The personalAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $personalAccount;
    /**
     * The correspAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $correspAccount;
    /**
     * The bankKPP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bankKPP;
    /**
     * Constructor method for BankRequisites
     * @uses BankRequisites::setBank()
     * @uses BankRequisites::setBankBIK()
     * @uses BankRequisites::setPaymentAccount()
     * @uses BankRequisites::setPersonalAccount()
     * @uses BankRequisites::setCorrespAccount()
     * @uses BankRequisites::setBankKPP()
     * @param string $bank
     * @param string $bankBIK
     * @param string $paymentAccount
     * @param string $personalAccount
     * @param string $correspAccount
     * @param string $bankKPP
     */
    public function __construct($bank = null, $bankBIK = null, $paymentAccount = null, $personalAccount = null, $correspAccount = null, $bankKPP = null)
    {
        $this
            ->setBank($bank)
            ->setBankBIK($bankBIK)
            ->setPaymentAccount($paymentAccount)
            ->setPersonalAccount($personalAccount)
            ->setCorrespAccount($correspAccount)
            ->setBankKPP($bankKPP);
    }
    /**
     * Get bank value
     * @return string|null
     */
    public function getBank()
    {
        return $this->bank;
    }
    /**
     * Set bank value
     * @param string $bank
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisites
     */
    public function setBank($bank = null)
    {
        $this->bank = $bank;
        return $this;
    }
    /**
     * Get bankBIK value
     * @return string|null
     */
    public function getBankBIK()
    {
        return $this->bankBIK;
    }
    /**
     * Set bankBIK value
     * @param string $bankBIK
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisites
     */
    public function setBankBIK($bankBIK = null)
    {
        $this->bankBIK = $bankBIK;
        return $this;
    }
    /**
     * Get paymentAccount value
     * @return string|null
     */
    public function getPaymentAccount()
    {
        return $this->paymentAccount;
    }
    /**
     * Set paymentAccount value
     * @param string $paymentAccount
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisites
     */
    public function setPaymentAccount($paymentAccount = null)
    {
        $this->paymentAccount = $paymentAccount;
        return $this;
    }
    /**
     * Get personalAccount value
     * @return string|null
     */
    public function getPersonalAccount()
    {
        return $this->personalAccount;
    }
    /**
     * Set personalAccount value
     * @param string $personalAccount
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisites
     */
    public function setPersonalAccount($personalAccount = null)
    {
        $this->personalAccount = $personalAccount;
        return $this;
    }
    /**
     * Get correspAccount value
     * @return string|null
     */
    public function getCorrespAccount()
    {
        return $this->correspAccount;
    }
    /**
     * Set correspAccount value
     * @param string $correspAccount
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisites
     */
    public function setCorrespAccount($correspAccount = null)
    {
        $this->correspAccount = $correspAccount;
        return $this;
    }
    /**
     * Get bankKPP value
     * @return string|null
     */
    public function getBankKPP()
    {
        return $this->bankKPP;
    }
    /**
     * Set bankKPP value
     * @param string $bankKPP
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisites
     */
    public function setBankKPP($bankKPP = null)
    {
        $this->bankKPP = $bankKPP;
        return $this;
    }
}
