<?php

namespace App\Integration\Providers\Alliance3;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Policy' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Policy',
            'beneficiaries' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Beneficiaries',
            'ProductInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ProductInfo',
            'InsCompInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\InsCompInfo',
            'SubjectInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\SubjectInfo',
            'PhysicalSubject' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PhysicalSubject',
            'DocumentInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DocumentInfo',
            'DocumentList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DocumentList',
            'AddressInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\AddressInfo',
            'BankDetails' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BankDetails',
            'PhysicalIdentificationDataInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PhysicalIdentificationDataInfo',
            'RelatedPdlInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\RelatedPdlInfo',
            'DirectoryElemStrInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DirectoryElemStrInfo',
            'TypePdlInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\TypePdlInfo',
            'JustificationRiskInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\JustificationRiskInfo',
            'FinancInformation' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\FinancInformation',
            'BusinessReputationInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BusinessReputationInfo',
            'JustificationNotIdentBenefInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\JustificationNotIdentBenefInfo',
            'VerificationBenefiziarInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\VerificationBenefiziarInfo',
            'JustificationNotIdentVigodInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\JustificationNotIdentVigodInfo',
            'IdentifBeneficiarListInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IdentifBeneficiarListInfo',
            'IdentifBeneficiarInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IdentifBeneficiarInfo',
            'PredstavitelListInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PredstavitelListInfo',
            'IdentificRepresentativeInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IdentificRepresentativeInfo',
            'BusinessLicenseList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BusinessLicenseList',
            'BusinessLicense' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BusinessLicense',
            'SourcesOfIncome' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\SourcesOfIncome',
            'JuridicalSubject' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\JuridicalSubject',
            'ContactPersontList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ContactPersontList',
            'ContactPerson' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ContactPerson',
            'SubjectListInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\SubjectListInfo',
            'ConstitutorListInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ConstitutorListInfo',
            'UchreditelInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\UchreditelInfo',
            'JuridicalIdentificationDataInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\JuridicalIdentificationDataInfo',
            'ManagementBodyStructInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ManagementBodyStructInfo',
            'IndivExecutBodyNameInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IndivExecutBodyNameInfo',
            'CollegExecutBodyNameInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CollegExecutBodyNameInfo',
            'ParametrList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ParametrList',
            'ParametrInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ParametrInfo',
            'InsuranceObjectList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\InsuranceObjectList',
            'InsuranceObject' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\InsuranceObject',
            'RiskInfoList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\RiskInfoList',
            'RiskInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\RiskInfo',
            'KoeffInfoList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\KoeffInfoList',
            'KoeffInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\KoeffInfo',
            'RepresentativeInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\RepresentativeInfo',
            'CurrencyExchList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CurrencyExchList',
            'CurrencyExch' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CurrencyExch',
            'DealerConractInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DealerConractInfo',
            'AgentConract' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\AgentConract',
            'GeneralConract' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GeneralConract',
            'PointOfSale' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PointOfSale',
            'UserInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\UserInfo',
            'PaymentList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PaymentList',
            'Payment' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Payment',
            'PaymentDocument' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PaymentDocument',
            'AgentSubject' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\AgentSubject',
            'InsuranceByPeriodList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\InsuranceByPeriodList',
            'InsuranceByPeriod' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\InsuranceByPeriod',
            'MarketProgrList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\MarketProgrList',
            'ReasonsForReplacementList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ReasonsForReplacementList',
            'PolicySequence' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PolicySequence',
            'BlankList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BlankList',
            'BlankEntry' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BlankEntry',
            'SubjectChangesInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\SubjectChangesInfo',
            'PhysicalSubjectChangesInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PhysicalSubjectChangesInfo',
            'JuridicalSubjectChanges' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\JuridicalSubjectChanges',
            'SubjectRepresentative' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\SubjectRepresentative',
            'BankRequisitesList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BankRequisitesList',
            'BankRequisites' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\BankRequisites',
            'Cross' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Cross',
            'Beneficiary' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Beneficiary',
            'PolicyStateHistoryList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PolicyStateHistoryList',
            'PolicyStateItem' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PolicyStateItem',
            'DictionaryConstraint' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DictionaryConstraint',
            'Constraint' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Constraint',
            'DictionaryList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DictionaryList',
            'DictionaryTypeList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DictionaryTypeList',
            'DictionaryType' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DictionaryType',
            'ParameterDictionaryTypeList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ParameterDictionaryTypeList',
            'ParameterDictionaryTypeInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ParameterDictionaryTypeInfo',
            'CalcListCodes' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CalcListCodes',
            'Dictionary' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Dictionary',
            'DictionaryValue' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DictionaryValue',
            'ParameterDictionaryInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ParameterDictionaryInfo',
            'ErrorList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ErrorList',
            'Error' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Error',
            'ExcelDictionaryParameter' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ExcelDictionaryParameter',
            'ExcelDictionaryCodes' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ExcelDictionaryCodes',
            'ExcelDictionaryResult' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ExcelDictionaryResult',
            'DictionaryAttributeValueList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DictionaryAttributeValueList',
            'DictionaryAttributeValue' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DictionaryAttributeValue',
            'DissolutionPolicyRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DissolutionPolicyRequest',
            'Dissolution' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\Dissolution',
            'DissolutionPolicyResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\DissolutionPolicyResponse',
            'CalcInsPremRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CalcInsPremRequest',
            'ParamDefaultList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ParamDefaultList',
            'CalcInsPremResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CalcInsPremResponse',
            'CalcPolicyResultList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CalcPolicyResultList',
            'CalcPolicyResult' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\CalcPolicyResult',
            'ParamDefaultValuesList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ParamDefaultValuesList',
            'getDictionaries' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionaries',
            'getDictionariesResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionariesResponse',
            'HideLoginRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\HideLoginRequest',
            'LoginRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\LoginRequest',
            'HideLoginResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\HideLoginResponse',
            'PrintPolicyRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PrintPolicyRequest',
            'PrintPolicyResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PrintPolicyResponse',
            'IssuePolicyRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IssuePolicyRequest',
            'IssuePolicyResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IssuePolicyResponse',
            'AnnulPolicyRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\AnnulPolicyRequest',
            'AnnulPolicyResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\AnnulPolicyResponse',
            'RequestsReplacePolicyOwnerRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\RequestsReplacePolicyOwnerRequest',
            'RequestsReplacePolicyOwnerResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\RequestsReplacePolicyOwnerResponse',
            'LogOutResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\LogOutResponse',
            'GetPaymentURLRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetPaymentURLRequest',
            'GetPaymentURLResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetPaymentURLResponse',
            'ErrorWithCodeList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ErrorWithCodeList',
            'ErrorWithCode' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ErrorWithCode',
            'AttachDocumentRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\AttachDocumentRequest',
            'AttachDocumentResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\AttachDocumentResponse',
            'SearchPoliciesRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\SearchPoliciesRequest',
            'SearchPoliciesResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\SearchPoliciesResponse',
            'PolicyShortInfoList' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PolicyShortInfoList',
            'PolicyShortInfo' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\PolicyShortInfo',
            'getAllDictionariesExcel' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetAllDictionariesExcel',
            'getAllDictionariesExcelResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetAllDictionariesExcelResponse',
            'getDictionaryValueCodesByAttribute' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionaryValueCodesByAttribute',
            'getDictionaryValueCodesByAttributeResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionaryValueCodesByAttributeResponse',
            'IssuePolicyAsyncRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IssuePolicyAsyncRequest',
            'IssuePolicyAsyncResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\IssuePolicyAsyncResponse',
            'getDictionaryAttributeValueByCode' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionaryAttributeValueByCode',
            'getDictionaryAttributeValueByCodeResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionaryAttributeValueByCodeResponse',
            'ImportPolicyRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ImportPolicyRequest',
            'ExternalSysUser' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ExternalSysUser',
            'ImportPolicyResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ImportPolicyResponse',
            'GetIssueProcessStatusRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetIssueProcessStatusRequest',
            'GetIssueProcessStatusResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetIssueProcessStatusResponse',
            'GetPolicyRequest' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetPolicyRequest',
            'GetPolicyResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetPolicyResponse',
            'LoginResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\LoginResponse',
            'getDictionaryByCode' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionaryByCode',
            'getDictionaryByCodeResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\GetDictionaryByCodeResponse',
            'ImportPolicyWOValidateResponse' => '\\App\\Integration\\Providers\\Alliance3\\DTO\\ImportPolicyWOValidateResponse',
        );
    }
}
