<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UchreditelInfo DTO
 * @subpackage Structs
 */
class UchreditelInfo extends AbstractStructBase
{
    /**
     * The share
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $share;
    /**
     * The constitutor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo
     */
    public $constitutor;
    /**
     * Constructor method for UchreditelInfo
     * @uses UchreditelInfo::setShare()
     * @uses UchreditelInfo::setConstitutor()
     * @param float $share
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $constitutor
     */
    public function __construct($share = null, \App\Integration\Providers\Alliance3\DTO\SubjectInfo $constitutor = null)
    {
        $this
            ->setShare($share)
            ->setConstitutor($constitutor);
    }
    /**
     * Get share value
     * @return float|null
     */
    public function getShare()
    {
        return $this->share;
    }
    /**
     * Set share value
     * @param float $share
     * @return \App\Integration\Providers\Alliance3\DTO\UchreditelInfo
     */
    public function setShare($share = null)
    {
        $this->share = $share;
        return $this;
    }
    /**
     * Get constitutor value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo|null
     */
    public function getConstitutor()
    {
        return $this->constitutor;
    }
    /**
     * Set constitutor value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $constitutor
     * @return \App\Integration\Providers\Alliance3\DTO\UchreditelInfo
     */
    public function setConstitutor(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $constitutor = null)
    {
        $this->constitutor = $constitutor;
        return $this;
    }
}
