<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubjectListInfo DTO
 * @subpackage Structs
 */
class SubjectListInfo extends AbstractStructBase
{
    /**
     * The subject
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\SubjectInfo[]
     */
    public $subject;
    /**
     * Constructor method for SubjectListInfo
     * @uses SubjectListInfo::setSubject()
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo[] $subject
     */
    public function __construct(array $subject = array())
    {
        $this
            ->setSubject($subject);
    }
    /**
     * Get subject value
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectInfo[]|null
     */
    public function getSubject()
    {
        return $this->subject;
    }
    /**
     * Set subject value
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo[] $subject
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectListInfo
     */
    public function setSubject(array $subject = array())
    {
        $this->subject = $subject;
        return $this;
    }
    /**
     * Add item to subject value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\SubjectInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\SubjectListInfo
     */
    public function addToSubject(\App\Integration\Providers\Alliance3\DTO\SubjectInfo $item)
    {
        $this->subject[] = $item;
        return $this;
    }
}
