<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointOfSale DTO
 * Meta information extracted from the WSDL
 * - type: tns:PointOfSale
 * @subpackage Structs
 */
class PointOfSale extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The subdivisionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subdivisionId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public $address;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ParametrList
     */
    public $parameters;
    /**
     * Constructor method for PointOfSale
     * @uses PointOfSale::setId()
     * @uses PointOfSale::setSubdivisionId()
     * @uses PointOfSale::setName()
     * @uses PointOfSale::setCode()
     * @uses PointOfSale::setPhone()
     * @uses PointOfSale::setAddress()
     * @uses PointOfSale::setParameters()
     * @param string $id
     * @param string $subdivisionId
     * @param string $name
     * @param string $code
     * @param string $phone
     * @param \App\Integration\Providers\Alliance3\DTO\AddressInfo $address
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     */
    public function __construct($id = null, $subdivisionId = null, $name = null, $code = null, $phone = null, \App\Integration\Providers\Alliance3\DTO\AddressInfo $address = null, \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null)
    {
        $this
            ->setId($id)
            ->setSubdivisionId($subdivisionId)
            ->setName($name)
            ->setCode($code)
            ->setPhone($phone)
            ->setAddress($address)
            ->setParameters($parameters);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get subdivisionId value
     * @return string|null
     */
    public function getSubdivisionId()
    {
        return $this->subdivisionId;
    }
    /**
     * Set subdivisionId value
     * @param string $subdivisionId
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public function setSubdivisionId($subdivisionId = null)
    {
        $this->subdivisionId = $subdivisionId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public function setPhone($phone = null)
    {
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get address value
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \App\Integration\Providers\Alliance3\DTO\AddressInfo $address
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public function setAddress(\App\Integration\Providers\Alliance3\DTO\AddressInfo $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get parameters value
     * @return \App\Integration\Providers\Alliance3\DTO\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\PointOfSale
     */
    public function setParameters(\App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
}
