<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentList DTO
 * @subpackage Structs
 */
class PaymentList extends AbstractStructBase
{
    /**
     * The payment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:payment
     * @var \App\Integration\Providers\Alliance3\DTO\Payment[]
     */
    public $payment;
    /**
     * Constructor method for PaymentList
     * @uses PaymentList::setPayment()
     * @param \App\Integration\Providers\Alliance3\DTO\Payment[] $payment
     */
    public function __construct(array $payment = array())
    {
        $this
            ->setPayment($payment);
    }
    /**
     * Get payment value
     * @return \App\Integration\Providers\Alliance3\DTO\Payment[]|null
     */
    public function getPayment()
    {
        return $this->payment;
    }
    /**
     * Set payment value
     * @param \App\Integration\Providers\Alliance3\DTO\Payment[] $payment
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentList
     */
    public function setPayment(array $payment = array())
    {
        $this->payment = $payment;
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\Payment $item
     * @return \App\Integration\Providers\Alliance3\DTO\PaymentList
     */
    public function addToPayment(\App\Integration\Providers\Alliance3\DTO\Payment $item)
    {
        $this->payment[] = $item;
        return $this;
    }
}
