<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginRequest DTO
 * @subpackage Structs
 */
class LoginRequest extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for LoginRequest
     * @uses LoginRequest::setLogin()
     * @uses LoginRequest::setPassword()
     * @param string $login
     * @param string $password
     */
    public function __construct($login = null, $password = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \App\Integration\Providers\Alliance3\DTO\LoginRequest
     */
    public function setLogin($login = null)
    {
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \App\Integration\Providers\Alliance3\DTO\LoginRequest
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
}
