<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceObjectList DTO
 * @subpackage Structs
 */
class InsuranceObjectList extends AbstractStructBase
{
    /**
     * The object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\InsuranceObject[]
     */
    public $object;
    /**
     * Constructor method for InsuranceObjectList
     * @uses InsuranceObjectList::setObject()
     * @param \App\Integration\Providers\Alliance3\DTO\InsuranceObject[] $object
     */
    public function __construct(array $object = array())
    {
        $this
            ->setObject($object);
    }
    /**
     * Get object value
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObject[]|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param \App\Integration\Providers\Alliance3\DTO\InsuranceObject[] $object
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObjectList
     */
    public function setObject(array $object = array())
    {
        $this->object = $object;
        return $this;
    }
    /**
     * Add item to object value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\InsuranceObject $item
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObjectList
     */
    public function addToObject(\App\Integration\Providers\Alliance3\DTO\InsuranceObject $item)
    {
        $this->object[] = $item;
        return $this;
    }
}
