<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceObject DTO
 * @subpackage Structs
 */
class InsuranceObject extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ParametrList
     */
    public $parameters;
    /**
     * The riskInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\RiskInfoList
     */
    public $riskInfo;
    /**
     * The alias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $alias;
    /**
     * Constructor method for InsuranceObject
     * @uses InsuranceObject::setName()
     * @uses InsuranceObject::setParameters()
     * @uses InsuranceObject::setRiskInfo()
     * @uses InsuranceObject::setAlias()
     * @param string $name
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     * @param \App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo
     * @param string $alias
     */
    public function __construct($name = null, \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null, \App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo = null, $alias = null)
    {
        $this
            ->setName($name)
            ->setParameters($parameters)
            ->setRiskInfo($riskInfo)
            ->setAlias($alias);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObject
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get parameters value
     * @return \App\Integration\Providers\Alliance3\DTO\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \App\Integration\Providers\Alliance3\DTO\ParametrList $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObject
     */
    public function setParameters(\App\Integration\Providers\Alliance3\DTO\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
    /**
     * Get riskInfo value
     * @return \App\Integration\Providers\Alliance3\DTO\RiskInfoList|null
     */
    public function getRiskInfo()
    {
        return $this->riskInfo;
    }
    /**
     * Set riskInfo value
     * @param \App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObject
     */
    public function setRiskInfo(\App\Integration\Providers\Alliance3\DTO\RiskInfoList $riskInfo = null)
    {
        $this->riskInfo = $riskInfo;
        return $this;
    }
    /**
     * Get alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->alias;
    }
    /**
     * Set alias value
     * @param string $alias
     * @return \App\Integration\Providers\Alliance3\DTO\InsuranceObject
     */
    public function setAlias($alias = null)
    {
        $this->alias = $alias;
        return $this;
    }
}
