<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcelDictionaryParameter DTO
 * Meta information extracted from the WSDL
 * - type: tns:ExcelDictionaryParameter
 * @subpackage Structs
 */
class ExcelDictionaryParameter extends AbstractStructBase
{
    /**
     * The ZipExcel
     * @var bool
     */
    public $ZipExcel;
    /**
     * The UseBase64
     * @var bool
     */
    public $UseBase64;
    /**
     * The DictionaryCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryCodes
     */
    public $DictionaryCodes;
    /**
     * Constructor method for ExcelDictionaryParameter
     * @uses ExcelDictionaryParameter::setZipExcel()
     * @uses ExcelDictionaryParameter::setUseBase64()
     * @uses ExcelDictionaryParameter::setDictionaryCodes()
     * @param bool $zipExcel
     * @param bool $useBase64
     * @param \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryCodes $dictionaryCodes
     */
    public function __construct($zipExcel = null, $useBase64 = null, \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryCodes $dictionaryCodes = null)
    {
        $this
            ->setZipExcel($zipExcel)
            ->setUseBase64($useBase64)
            ->setDictionaryCodes($dictionaryCodes);
    }
    /**
     * Get ZipExcel value
     * @return bool|null
     */
    public function getZipExcel()
    {
        return $this->ZipExcel;
    }
    /**
     * Set ZipExcel value
     * @param bool $zipExcel
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryParameter
     */
    public function setZipExcel($zipExcel = null)
    {
        $this->ZipExcel = $zipExcel;
        return $this;
    }
    /**
     * Get UseBase64 value
     * @return bool|null
     */
    public function getUseBase64()
    {
        return $this->UseBase64;
    }
    /**
     * Set UseBase64 value
     * @param bool $useBase64
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryParameter
     */
    public function setUseBase64($useBase64 = null)
    {
        $this->UseBase64 = $useBase64;
        return $this;
    }
    /**
     * Get DictionaryCodes value
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryCodes|null
     */
    public function getDictionaryCodes()
    {
        return $this->DictionaryCodes;
    }
    /**
     * Set DictionaryCodes value
     * @param \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryCodes $dictionaryCodes
     * @return \App\Integration\Providers\Alliance3\DTO\ExcelDictionaryParameter
     */
    public function setDictionaryCodes(\App\Integration\Providers\Alliance3\DTO\ExcelDictionaryCodes $dictionaryCodes = null)
    {
        $this->DictionaryCodes = $dictionaryCodes;
        return $this;
    }
}
