<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dissolution DTO
 * Meta information extracted from the WSDL
 * - type: tns:Dissolution
 * @subpackage Structs
 */
class Dissolution extends AbstractStructBase
{
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The seriaPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seriaPolicy;
    /**
     * The numberPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numberPolicy;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The dateOfEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateOfEvent;
    /**
     * The refundSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $refundSum;
    /**
     * Constructor method for Dissolution
     * @uses Dissolution::setPolicyID()
     * @uses Dissolution::setProductType()
     * @uses Dissolution::setSeriaPolicy()
     * @uses Dissolution::setNumberPolicy()
     * @uses Dissolution::setReason()
     * @uses Dissolution::setDate()
     * @uses Dissolution::setDateOfEvent()
     * @uses Dissolution::setRefundSum()
     * @param string $policyID
     * @param string $productType
     * @param string $seriaPolicy
     * @param string $numberPolicy
     * @param string $reason
     * @param string $date
     * @param string $dateOfEvent
     * @param float $refundSum
     */
    public function __construct($policyID = null, $productType = null, $seriaPolicy = null, $numberPolicy = null, $reason = null, $date = null, $dateOfEvent = null, $refundSum = null)
    {
        $this
            ->setPolicyID($policyID)
            ->setProductType($productType)
            ->setSeriaPolicy($seriaPolicy)
            ->setNumberPolicy($numberPolicy)
            ->setReason($reason)
            ->setDate($date)
            ->setDateOfEvent($dateOfEvent)
            ->setRefundSum($refundSum);
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setPolicyID($policyID = null)
    {
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setProductType($productType = null)
    {
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get seriaPolicy value
     * @return string|null
     */
    public function getSeriaPolicy()
    {
        return $this->seriaPolicy;
    }
    /**
     * Set seriaPolicy value
     * @param string $seriaPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setSeriaPolicy($seriaPolicy = null)
    {
        $this->seriaPolicy = $seriaPolicy;
        return $this;
    }
    /**
     * Get numberPolicy value
     * @return string|null
     */
    public function getNumberPolicy()
    {
        return $this->numberPolicy;
    }
    /**
     * Set numberPolicy value
     * @param string $numberPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setNumberPolicy($numberPolicy = null)
    {
        $this->numberPolicy = $numberPolicy;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setReason($reason = null)
    {
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setDate($date = null)
    {
        $this->date = $date;
        return $this;
    }
    /**
     * Get dateOfEvent value
     * @return string|null
     */
    public function getDateOfEvent()
    {
        return $this->dateOfEvent;
    }
    /**
     * Set dateOfEvent value
     * @param string $dateOfEvent
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setDateOfEvent($dateOfEvent = null)
    {
        $this->dateOfEvent = $dateOfEvent;
        return $this;
    }
    /**
     * Get refundSum value
     * @return float|null
     */
    public function getRefundSum()
    {
        return $this->refundSum;
    }
    /**
     * Set refundSum value
     * @param float $refundSum
     * @return \App\Integration\Providers\Alliance3\DTO\Dissolution
     */
    public function setRefundSum($refundSum = null)
    {
        $this->refundSum = $refundSum;
        return $this;
    }
}
