<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryValue DTO
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryValue
 * @subpackage Structs
 */
class DictionaryValue extends AbstractStructBase
{
    /**
     * The ValueCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ValueCode;
    /**
     * The Parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo[]
     */
    public $Parameter;
    /**
     * Constructor method for DictionaryValue
     * @uses DictionaryValue::setValueCode()
     * @uses DictionaryValue::setParameter()
     * @param string $valueCode
     * @param \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo[] $parameter
     */
    public function __construct($valueCode = null, array $parameter = array())
    {
        $this
            ->setValueCode($valueCode)
            ->setParameter($parameter);
    }
    /**
     * Get ValueCode value
     * @return string|null
     */
    public function getValueCode()
    {
        return $this->ValueCode;
    }
    /**
     * Set ValueCode value
     * @param string $valueCode
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryValue
     */
    public function setValueCode($valueCode = null)
    {
        $this->ValueCode = $valueCode;
        return $this;
    }
    /**
     * Get Parameter value
     * @return \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo[]|null
     */
    public function getParameter()
    {
        return $this->Parameter;
    }
    /**
     * Set Parameter value
     * @param \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo[] $parameter
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryValue
     */
    public function setParameter(array $parameter = array())
    {
        $this->Parameter = $parameter;
        return $this;
    }
    /**
     * Add item to Parameter value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo $item
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryValue
     */
    public function addToParameter(\App\Integration\Providers\Alliance3\DTO\ParameterDictionaryInfo $item)
    {
        $this->Parameter[] = $item;
        return $this;
    }
}
