<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryAttributeValue DTO
 * Meta information extracted from the WSDL
 * - type: tns:DictionaryAttributeValue
 * @subpackage Structs
 */
class DictionaryAttributeValue extends AbstractStructBase
{
    /**
     * The DictionaryValueCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DictionaryValueCode;
    /**
     * The AttributeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttributeCode;
    /**
     * The AttributeValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttributeValue;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ErrorList
     */
    public $Errors;
    /**
     * Constructor method for DictionaryAttributeValue
     * @uses DictionaryAttributeValue::setDictionaryValueCode()
     * @uses DictionaryAttributeValue::setAttributeCode()
     * @uses DictionaryAttributeValue::setAttributeValue()
     * @uses DictionaryAttributeValue::setErrors()
     * @param string $dictionaryValueCode
     * @param string $attributeCode
     * @param string $attributeValue
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     */
    public function __construct($dictionaryValueCode = null, $attributeCode = null, $attributeValue = null, \App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null)
    {
        $this
            ->setDictionaryValueCode($dictionaryValueCode)
            ->setAttributeCode($attributeCode)
            ->setAttributeValue($attributeValue)
            ->setErrors($errors);
    }
    /**
     * Get DictionaryValueCode value
     * @return string|null
     */
    public function getDictionaryValueCode()
    {
        return $this->DictionaryValueCode;
    }
    /**
     * Set DictionaryValueCode value
     * @param string $dictionaryValueCode
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue
     */
    public function setDictionaryValueCode($dictionaryValueCode = null)
    {
        $this->DictionaryValueCode = $dictionaryValueCode;
        return $this;
    }
    /**
     * Get AttributeCode value
     * @return string|null
     */
    public function getAttributeCode()
    {
        return $this->AttributeCode;
    }
    /**
     * Set AttributeCode value
     * @param string $attributeCode
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue
     */
    public function setAttributeCode($attributeCode = null)
    {
        $this->AttributeCode = $attributeCode;
        return $this;
    }
    /**
     * Get AttributeValue value
     * @return string|null
     */
    public function getAttributeValue()
    {
        return $this->AttributeValue;
    }
    /**
     * Set AttributeValue value
     * @param string $attributeValue
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue
     */
    public function setAttributeValue($attributeValue = null)
    {
        $this->AttributeValue = $attributeValue;
        return $this;
    }
    /**
     * Get Errors value
     * @return \App\Integration\Providers\Alliance3\DTO\ErrorList|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \App\Integration\Providers\Alliance3\DTO\ErrorList $errors
     * @return \App\Integration\Providers\Alliance3\DTO\DictionaryAttributeValue
     */
    public function setErrors(\App\Integration\Providers\Alliance3\DTO\ErrorList $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
}
