<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactPersontList DTO
 * @subpackage Structs
 */
class ContactPersontList extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\ContactPerson[]
     */
    public $contact;
    /**
     * Constructor method for ContactPersontList
     * @uses ContactPersontList::setContact()
     * @param \App\Integration\Providers\Alliance3\DTO\ContactPerson[] $contact
     */
    public function __construct(array $contact = array())
    {
        $this
            ->setContact($contact);
    }
    /**
     * Get contact value
     * @return \App\Integration\Providers\Alliance3\DTO\ContactPerson[]|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \App\Integration\Providers\Alliance3\DTO\ContactPerson[] $contact
     * @return \App\Integration\Providers\Alliance3\DTO\ContactPersontList
     */
    public function setContact(array $contact = array())
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Add item to contact value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\ContactPerson $item
     * @return \App\Integration\Providers\Alliance3\DTO\ContactPersontList
     */
    public function addToContact(\App\Integration\Providers\Alliance3\DTO\ContactPerson $item)
    {
        $this->contact[] = $item;
        return $this;
    }
}
