<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessLicenseList DTO
 * @subpackage Structs
 */
class BusinessLicenseList extends AbstractStructBase
{
    /**
     * The license
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\BusinessLicense[]
     */
    public $license;
    /**
     * Constructor method for BusinessLicenseList
     * @uses BusinessLicenseList::setLicense()
     * @param \App\Integration\Providers\Alliance3\DTO\BusinessLicense[] $license
     */
    public function __construct(array $license = array())
    {
        $this
            ->setLicense($license);
    }
    /**
     * Get license value
     * @return \App\Integration\Providers\Alliance3\DTO\BusinessLicense[]|null
     */
    public function getLicense()
    {
        return $this->license;
    }
    /**
     * Set license value
     * @param \App\Integration\Providers\Alliance3\DTO\BusinessLicense[] $license
     * @return \App\Integration\Providers\Alliance3\DTO\BusinessLicenseList
     */
    public function setLicense(array $license = array())
    {
        $this->license = $license;
        return $this;
    }
    /**
     * Add item to license value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\BusinessLicense $item
     * @return \App\Integration\Providers\Alliance3\DTO\BusinessLicenseList
     */
    public function addToLicense(\App\Integration\Providers\Alliance3\DTO\BusinessLicense $item)
    {
        $this->license[] = $item;
        return $this;
    }
}
