<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for beneficiaries DTO
 * @subpackage Structs
 */
class Beneficiaries extends AbstractStructBase
{
    /**
     * The beneficiary
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:beneficiary
     * @var \App\Integration\Providers\Alliance3\DTO\Beneficiary[]
     */
    public $beneficiary;
    /**
     * Constructor method for beneficiaries
     * @uses Beneficiaries::setBeneficiary()
     * @param \App\Integration\Providers\Alliance3\DTO\Beneficiary[] $beneficiary
     */
    public function __construct(array $beneficiary = array())
    {
        $this
            ->setBeneficiary($beneficiary);
    }
    /**
     * Get beneficiary value
     * @return \App\Integration\Providers\Alliance3\DTO\Beneficiary[]|null
     */
    public function getBeneficiary()
    {
        return $this->beneficiary;
    }
    /**
     * Set beneficiary value
     * @param \App\Integration\Providers\Alliance3\DTO\Beneficiary[] $beneficiary
     * @return \App\Integration\Providers\Alliance3\DTO\Beneficiaries
     */
    public function setBeneficiary(array $beneficiary = array())
    {
        $this->beneficiary = $beneficiary;
        return $this;
    }
    /**
     * Add item to beneficiary value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\Beneficiary $item
     * @return \App\Integration\Providers\Alliance3\DTO\Beneficiaries
     */
    public function addToBeneficiary(\App\Integration\Providers\Alliance3\DTO\Beneficiary $item)
    {
        $this->beneficiary[] = $item;
        return $this;
    }
}
