<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankRequisitesList DTO
 * @subpackage Structs
 */
class BankRequisitesList extends AbstractStructBase
{
    /**
     * The requisites
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Integration\Providers\Alliance3\DTO\BankRequisites[]
     */
    public $requisites;
    /**
     * Constructor method for BankRequisitesList
     * @uses BankRequisitesList::setRequisites()
     * @param \App\Integration\Providers\Alliance3\DTO\BankRequisites[] $requisites
     */
    public function __construct(array $requisites = array())
    {
        $this
            ->setRequisites($requisites);
    }
    /**
     * Get requisites value
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisites[]|null
     */
    public function getRequisites()
    {
        return $this->requisites;
    }
    /**
     * Set requisites value
     * @param \App\Integration\Providers\Alliance3\DTO\BankRequisites[] $requisites
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisitesList
     */
    public function setRequisites(array $requisites = array())
    {
        $this->requisites = $requisites;
        return $this;
    }
    /**
     * Add item to requisites value
     * @throws \InvalidArgumentException
     * @param \App\Integration\Providers\Alliance3\DTO\BankRequisites $item
     * @return \App\Integration\Providers\Alliance3\DTO\BankRequisitesList
     */
    public function addToRequisites(\App\Integration\Providers\Alliance3\DTO\BankRequisites $item)
    {
        $this->requisites[] = $item;
        return $this;
    }
}
