<?php

namespace App\Integration\Providers\Alliance3\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressInfo DTO
 * @subpackage Structs
 */
class AddressInfo extends AbstractStructBase
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The countryCodeOKSM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryCodeOKSM;
    /**
     * The postIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postIndex;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The district
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $district;
    /**
     * The locality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locality;
    /**
     * The localityCodeKLADR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localityCodeKLADR;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * The houseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $houseNumber;
    /**
     * The houseCorps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $houseCorps;
    /**
     * The houseBuilding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $houseBuilding;
    /**
     * The flat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flat;
    /**
     * The addressText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressText;
    /**
     * The addressLat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $addressLat;
    /**
     * The okato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $okato;
    /**
     * Constructor method for AddressInfo
     * @uses AddressInfo::setCountry()
     * @uses AddressInfo::setCountryCodeOKSM()
     * @uses AddressInfo::setPostIndex()
     * @uses AddressInfo::setRegion()
     * @uses AddressInfo::setDistrict()
     * @uses AddressInfo::setLocality()
     * @uses AddressInfo::setLocalityCodeKLADR()
     * @uses AddressInfo::setStreet()
     * @uses AddressInfo::setHouseNumber()
     * @uses AddressInfo::setHouseCorps()
     * @uses AddressInfo::setHouseBuilding()
     * @uses AddressInfo::setFlat()
     * @uses AddressInfo::setAddressText()
     * @uses AddressInfo::setAddressLat()
     * @uses AddressInfo::setOkato()
     * @param string $country
     * @param string $countryCodeOKSM
     * @param string $postIndex
     * @param string $region
     * @param string $district
     * @param string $locality
     * @param string $localityCodeKLADR
     * @param string $street
     * @param string $houseNumber
     * @param string $houseCorps
     * @param int $houseBuilding
     * @param string $flat
     * @param string $addressText
     * @param string $addressLat
     * @param string $okato
     */
    public function __construct($country = null, $countryCodeOKSM = null, $postIndex = null, $region = null, $district = null, $locality = null, $localityCodeKLADR = null, $street = null, $houseNumber = null, $houseCorps = null, $houseBuilding = null, $flat = null, $addressText = null, $addressLat = null, $okato = null)
    {
        $this
            ->setCountry($country)
            ->setCountryCodeOKSM($countryCodeOKSM)
            ->setPostIndex($postIndex)
            ->setRegion($region)
            ->setDistrict($district)
            ->setLocality($locality)
            ->setLocalityCodeKLADR($localityCodeKLADR)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setHouseCorps($houseCorps)
            ->setHouseBuilding($houseBuilding)
            ->setFlat($flat)
            ->setAddressText($addressText)
            ->setAddressLat($addressLat)
            ->setOkato($okato);
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setCountry($country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get countryCodeOKSM value
     * @return string|null
     */
    public function getCountryCodeOKSM()
    {
        return $this->countryCodeOKSM;
    }
    /**
     * Set countryCodeOKSM value
     * @param string $countryCodeOKSM
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setCountryCodeOKSM($countryCodeOKSM = null)
    {
        $this->countryCodeOKSM = $countryCodeOKSM;
        return $this;
    }
    /**
     * Get postIndex value
     * @return string|null
     */
    public function getPostIndex()
    {
        return $this->postIndex;
    }
    /**
     * Set postIndex value
     * @param string $postIndex
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setPostIndex($postIndex = null)
    {
        $this->postIndex = $postIndex;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setRegion($region = null)
    {
        $this->region = $region;
        return $this;
    }
    /**
     * Get district value
     * @return string|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param string $district
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setDistrict($district = null)
    {
        $this->district = $district;
        return $this;
    }
    /**
     * Get locality value
     * @return string|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param string $locality
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setLocality($locality = null)
    {
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get localityCodeKLADR value
     * @return string|null
     */
    public function getLocalityCodeKLADR()
    {
        return $this->localityCodeKLADR;
    }
    /**
     * Set localityCodeKLADR value
     * @param string $localityCodeKLADR
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setLocalityCodeKLADR($localityCodeKLADR = null)
    {
        $this->localityCodeKLADR = $localityCodeKLADR;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setStreet($street = null)
    {
        $this->street = $street;
        return $this;
    }
    /**
     * Get houseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }
    /**
     * Set houseNumber value
     * @param string $houseNumber
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setHouseNumber($houseNumber = null)
    {
        $this->houseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get houseCorps value
     * @return string|null
     */
    public function getHouseCorps()
    {
        return $this->houseCorps;
    }
    /**
     * Set houseCorps value
     * @param string $houseCorps
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setHouseCorps($houseCorps = null)
    {
        $this->houseCorps = $houseCorps;
        return $this;
    }
    /**
     * Get houseBuilding value
     * @return int|null
     */
    public function getHouseBuilding()
    {
        return $this->houseBuilding;
    }
    /**
     * Set houseBuilding value
     * @param int $houseBuilding
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setHouseBuilding($houseBuilding = null)
    {
        $this->houseBuilding = $houseBuilding;
        return $this;
    }
    /**
     * Get flat value
     * @return string|null
     */
    public function getFlat()
    {
        return $this->flat;
    }
    /**
     * Set flat value
     * @param string $flat
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setFlat($flat = null)
    {
        $this->flat = $flat;
        return $this;
    }
    /**
     * Get addressText value
     * @return string|null
     */
    public function getAddressText()
    {
        return $this->addressText;
    }
    /**
     * Set addressText value
     * @param string $addressText
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setAddressText($addressText = null)
    {
        $this->addressText = $addressText;
        return $this;
    }
    /**
     * Get addressLat value
     * @return string|null
     */
    public function getAddressLat()
    {
        return $this->addressLat;
    }
    /**
     * Set addressLat value
     * @param string $addressLat
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setAddressLat($addressLat = null)
    {
        $this->addressLat = $addressLat;
        return $this;
    }
    /**
     * Get okato value
     * @return string|null
     */
    public function getOkato()
    {
        return $this->okato;
    }
    /**
     * Set okato value
     * @param string $okato
     * @return \App\Integration\Providers\Alliance3\DTO\AddressInfo
     */
    public function setOkato($okato = null)
    {
        $this->okato = $okato;
        return $this;
    }
}
