<?php

namespace App\Integration\Providers\Alliance3\Actions;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @subpackage Services
 */
class Service extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetPolicyRequest $getPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\GetPolicyResponse|bool
     */
    public function getPolicy(\App\Integration\Providers\Alliance3\DTO\GetPolicyRequest $getPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->getPolicy($getPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionaryByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetDictionaryByCode $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\GetDictionaryByCodeResponse|bool
     */
    public function getDictionaryByCode(\App\Integration\Providers\Alliance3\DTO\GetDictionaryByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaryByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAllDictionariesExcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetAllDictionariesExcel $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\GetAllDictionariesExcelResponse|bool
     */
    public function getAllDictionariesExcel(\App\Integration\Providers\Alliance3\DTO\GetAllDictionariesExcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAllDictionariesExcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionaryValueCodesByAttribute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetDictionaryValueCodesByAttribute $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\GetDictionaryValueCodesByAttributeResponse|bool
     */
    public function getDictionaryValueCodesByAttribute(\App\Integration\Providers\Alliance3\DTO\GetDictionaryValueCodesByAttribute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaryValueCodesByAttribute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionaryAttributeValueByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetDictionaryAttributeValueByCode $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\GetDictionaryAttributeValueByCodeResponse|bool
     */
    public function getDictionaryAttributeValueByCode(\App\Integration\Providers\Alliance3\DTO\GetDictionaryAttributeValueByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaryAttributeValueByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getHashByPolicyCalcId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\RequestsReplacePolicyOwnerRequest $getHashByPolicyCalcId
     * @return \App\Integration\Providers\Alliance3\DTO\RequestsReplacePolicyOwnerResponse|bool
     */
    public function getHashByPolicyCalcId(\App\Integration\Providers\Alliance3\DTO\RequestsReplacePolicyOwnerRequest $getHashByPolicyCalcId)
    {
        try {
            $this->setResult($this->getSoapClient()->getHashByPolicyCalcId($getHashByPolicyCalcId));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importPolicyWOValidation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\ImportPolicyRequest $importPolicyWOValidation
     * @return \App\Integration\Providers\Alliance3\DTO\ImportPolicyWOValidateResponse|bool
     */
    public function importPolicyWOValidation(\App\Integration\Providers\Alliance3\DTO\ImportPolicyRequest $importPolicyWOValidation)
    {
        try {
            $this->setResult($this->getSoapClient()->importPolicyWOValidation($importPolicyWOValidation));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIssueProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetIssueProcessStatusRequest $getIssueProcessStatus
     * @return \App\Integration\Providers\Alliance3\DTO\GetIssueProcessStatusResponse|bool
     */
    public function getIssueProcessStatus(\App\Integration\Providers\Alliance3\DTO\GetIssueProcessStatusRequest $getIssueProcessStatus)
    {
        try {
            $this->setResult($this->getSoapClient()->getIssueProcessStatus($getIssueProcessStatus));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named attachDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\AttachDocumentRequest $attachDocument
     * @return \App\Integration\Providers\Alliance3\DTO\AttachDocumentResponse|bool
     */
    public function attachDocument(\App\Integration\Providers\Alliance3\DTO\AttachDocumentRequest $attachDocument)
    {
        try {
            $this->setResult($this->getSoapClient()->attachDocument($attachDocument));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named printPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\PrintPolicyRequest $printPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\PrintPolicyResponse|bool
     */
    public function printPolicy(\App\Integration\Providers\Alliance3\DTO\PrintPolicyRequest $printPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->printPolicy($printPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getDictionaries
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetDictionaries $parameters
     * @return \App\Integration\Providers\Alliance3\DTO\GetDictionariesResponse|bool
     */
    public function getDictionaries(\App\Integration\Providers\Alliance3\DTO\GetDictionaries $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getDictionaries($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named logIn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\LoginRequest $logIn
     * @return \App\Integration\Providers\Alliance3\DTO\LoginResponse|bool
     */
    public function logIn(\App\Integration\Providers\Alliance3\DTO\LoginRequest $logIn)
    {
        try {
            $this->setResult($this->getSoapClient()->logIn($logIn));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named importPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\ImportPolicyRequest $importPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\ImportPolicyResponse|bool
     */
    public function importPolicy(\App\Integration\Providers\Alliance3\DTO\ImportPolicyRequest $importPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->importPolicy($importPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named issuePolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\IssuePolicyRequest $issuePolicy
     * @return \App\Integration\Providers\Alliance3\DTO\IssuePolicyResponse|bool
     */
    public function issuePolicy(\App\Integration\Providers\Alliance3\DTO\IssuePolicyRequest $issuePolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->issuePolicy($issuePolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named calcByProductType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\CalcInsPremRequest $calcByProductType
     * @return \App\Integration\Providers\Alliance3\DTO\CalcInsPremResponse|bool
     */
    public function calcByProductType(\App\Integration\Providers\Alliance3\DTO\CalcInsPremRequest $calcByProductType)
    {
        try {
            $this->setResult($this->getSoapClient()->calcByProductType($calcByProductType));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPaymentURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest $getPaymentURL
     * @return \App\Integration\Providers\Alliance3\DTO\GetPaymentURLResponse|bool
     */
    public function getPaymentURL(\App\Integration\Providers\Alliance3\DTO\GetPaymentURLRequest $getPaymentURL)
    {
        try {
            $this->setResult($this->getSoapClient()->getPaymentURL($getPaymentURL));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named dissolutionPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\DissolutionPolicyRequest $dissolutionPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\DissolutionPolicyResponse|bool
     */
    public function dissolutionPolicy(\App\Integration\Providers\Alliance3\DTO\DissolutionPolicyRequest $dissolutionPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->dissolutionPolicy($dissolutionPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchPolicies
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\SearchPoliciesRequest $searchPolicies
     * @return \App\Integration\Providers\Alliance3\DTO\SearchPoliciesResponse|bool
     */
    public function searchPolicies(\App\Integration\Providers\Alliance3\DTO\SearchPoliciesRequest $searchPolicies)
    {
        try {
            $this->setResult($this->getSoapClient()->searchPolicies($searchPolicies));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named hideLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\HideLoginRequest $hideLogin
     * @return \App\Integration\Providers\Alliance3\DTO\HideLoginResponse|bool
     */
    public function hideLogin(\App\Integration\Providers\Alliance3\DTO\HideLoginRequest $hideLogin)
    {
        try {
            $this->setResult($this->getSoapClient()->hideLogin($hideLogin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named issuePolicyAsync
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\IssuePolicyAsyncRequest $issuePolicyAsync
     * @return \App\Integration\Providers\Alliance3\DTO\IssuePolicyAsyncResponse|bool
     */
    public function issuePolicyAsync(\App\Integration\Providers\Alliance3\DTO\IssuePolicyAsyncRequest $issuePolicyAsync)
    {
        try {
            $this->setResult($this->getSoapClient()->issuePolicyAsync($issuePolicyAsync));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named logOut
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $logOut
     * @return \App\Integration\Providers\Alliance3\DTO\LogOutResponse|bool
     */
    public function logOut($logOut)
    {
        try {
            $this->setResult($this->getSoapClient()->logOut($logOut));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named annulPolicy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\AnnulPolicyRequest $annulPolicy
     * @return \App\Integration\Providers\Alliance3\DTO\AnnulPolicyResponse|bool
     */
    public function annulPolicy(\App\Integration\Providers\Alliance3\DTO\AnnulPolicyRequest $annulPolicy)
    {
        try {
            $this->setResult($this->getSoapClient()->annulPolicy($annulPolicy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named printPolicyByState
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Integration\Providers\Alliance3\DTO\PrintPolicyRequest $printPolicyByState
     * @return \App\Integration\Providers\Alliance3\DTO\PrintPolicyResponse|bool
     */
    public function printPolicyByState(\App\Integration\Providers\Alliance3\DTO\PrintPolicyRequest $printPolicyByState)
    {
        try {
            $this->setResult($this->getSoapClient()->printPolicyByState($printPolicyByState));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Integration\Providers\Alliance3\DTO\AnnulPolicyResponse|\App\Integration\Providers\Alliance3\DTO\AttachDocumentResponse|\App\Integration\Providers\Alliance3\DTO\CalcInsPremResponse|\App\Integration\Providers\Alliance3\DTO\DissolutionPolicyResponse|\App\Integration\Providers\Alliance3\DTO\GetAllDictionariesExcelResponse|\App\Integration\Providers\Alliance3\DTO\GetDictionariesResponse|\App\Integration\Providers\Alliance3\DTO\GetDictionaryAttributeValueByCodeResponse|\App\Integration\Providers\Alliance3\DTO\GetDictionaryByCodeResponse|\App\Integration\Providers\Alliance3\DTO\GetDictionaryValueCodesByAttributeResponse|\App\Integration\Providers\Alliance3\DTO\GetIssueProcessStatusResponse|\App\Integration\Providers\Alliance3\DTO\GetPaymentURLResponse|\App\Integration\Providers\Alliance3\DTO\GetPolicyResponse|\App\Integration\Providers\Alliance3\DTO\HideLoginResponse|\App\Integration\Providers\Alliance3\DTO\ImportPolicyResponse|\App\Integration\Providers\Alliance3\DTO\ImportPolicyWOValidateResponse|\App\Integration\Providers\Alliance3\DTO\IssuePolicyAsyncResponse|\App\Integration\Providers\Alliance3\DTO\IssuePolicyResponse|\App\Integration\Providers\Alliance3\DTO\LoginResponse|\App\Integration\Providers\Alliance3\DTO\LogOutResponse|\App\Integration\Providers\Alliance3\DTO\PrintPolicyResponse|\App\Integration\Providers\Alliance3\DTO\RequestsReplacePolicyOwnerResponse|\App\Integration\Providers\Alliance3\DTO\SearchPoliciesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
