<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetornoGrabacionEnvio StructType
 * @subpackage Structs
 */
class RetornoGrabacionEnvio extends RetornoAbstract
{
    /**
     * The datosResultado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datosResultado;
    /**
     * The envio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $envio;
    /**
     * The listaBultos
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Bulto[]
     */
    public $listaBultos;
    /**
     * The resultado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resultado;
    /**
     * Constructor method for RetornoGrabacionEnvio
     * @uses RetornoGrabacionEnvio::setDatosResultado()
     * @uses RetornoGrabacionEnvio::setEnvio()
     * @uses RetornoGrabacionEnvio::setListaBultos()
     * @uses RetornoGrabacionEnvio::setResultado()
     * @param string $datosResultado
     * @param string $envio
     * @param \StructType\Bulto[] $listaBultos
     * @param string $resultado
     */
    public function __construct($datosResultado = null, $envio = null, array $listaBultos = array(), $resultado = null)
    {
        $this
            ->setDatosResultado($datosResultado)
            ->setEnvio($envio)
            ->setListaBultos($listaBultos)
            ->setResultado($resultado);
    }
    /**
     * Get datosResultado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatosResultado()
    {
        return isset($this->datosResultado) ? $this->datosResultado : null;
    }
    /**
     * Set datosResultado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datosResultado
     * @return \StructType\RetornoGrabacionEnvio
     */
    public function setDatosResultado($datosResultado = null)
    {
        // validation for constraint: string
        if (!is_null($datosResultado) && !is_string($datosResultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datosResultado)), __LINE__);
        }
        if (is_null($datosResultado) || (is_array($datosResultado) && empty($datosResultado))) {
            unset($this->datosResultado);
        } else {
            $this->datosResultado = $datosResultado;
        }
        return $this;
    }
    /**
     * Get envio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnvio()
    {
        return isset($this->envio) ? $this->envio : null;
    }
    /**
     * Set envio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $envio
     * @return \StructType\RetornoGrabacionEnvio
     */
    public function setEnvio($envio = null)
    {
        // validation for constraint: string
        if (!is_null($envio) && !is_string($envio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($envio)), __LINE__);
        }
        if (is_null($envio) || (is_array($envio) && empty($envio))) {
            unset($this->envio);
        } else {
            $this->envio = $envio;
        }
        return $this;
    }
    /**
     * Get listaBultos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Bulto[]|null
     */
    public function getListaBultos()
    {
        return isset($this->listaBultos) ? $this->listaBultos : null;
    }
    /**
     * Set listaBultos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Bulto[] $listaBultos
     * @return \StructType\RetornoGrabacionEnvio
     */
    public function setListaBultos(array $listaBultos = array())
    {
        foreach ($listaBultos as $retornoGrabacionEnvioListaBultosItem) {
            // validation for constraint: itemType
            if (!$retornoGrabacionEnvioListaBultosItem instanceof \StructType\Bulto) {
                throw new \InvalidArgumentException(sprintf('The listaBultos property can only contain items of \StructType\Bulto, "%s" given', is_object($retornoGrabacionEnvioListaBultosItem) ? get_class($retornoGrabacionEnvioListaBultosItem) : gettype($retornoGrabacionEnvioListaBultosItem)), __LINE__);
            }
        }
        if (is_null($listaBultos) || (is_array($listaBultos) && empty($listaBultos))) {
            unset($this->listaBultos);
        } else {
            $this->listaBultos = $listaBultos;
        }
        return $this;
    }
    /**
     * Add item to listaBultos value
     * @throws \InvalidArgumentException
     * @param \StructType\Bulto $item
     * @return \StructType\RetornoGrabacionEnvio
     */
    public function addToListaBultos(\StructType\Bulto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bulto) {
            throw new \InvalidArgumentException(sprintf('The listaBultos property can only contain items of \StructType\Bulto, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->listaBultos[] = $item;
        return $this;
    }
    /**
     * Get resultado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultado()
    {
        return isset($this->resultado) ? $this->resultado : null;
    }
    /**
     * Set resultado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultado
     * @return \StructType\RetornoGrabacionEnvio
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: string
        if (!is_null($resultado) && !is_string($resultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultado)), __LINE__);
        }
        if (is_null($resultado) || (is_array($resultado) && empty($resultado))) {
            unset($this->resultado);
        } else {
            $this->resultado = $resultado;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetornoGrabacionEnvio
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
