<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetornoAbstract StructType
 * @subpackage Structs
 */
class RetornoAbstract extends AbstractStructBase
{
    /**
     * The codigoRetorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigoRetorno;
    /**
     * The mensajeRetorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mensajeRetorno;
    /**
     * Constructor method for RetornoAbstract
     * @uses RetornoAbstract::setCodigoRetorno()
     * @uses RetornoAbstract::setMensajeRetorno()
     * @param int $codigoRetorno
     * @param string $mensajeRetorno
     */
    public function __construct($codigoRetorno = null, $mensajeRetorno = null)
    {
        $this
            ->setCodigoRetorno($codigoRetorno)
            ->setMensajeRetorno($mensajeRetorno);
    }
    /**
     * Get codigoRetorno value
     * @return int|null
     */
    public function getCodigoRetorno()
    {
        return $this->codigoRetorno;
    }
    /**
     * Set codigoRetorno value
     * @param int $codigoRetorno
     * @return \StructType\RetornoAbstract
     */
    public function setCodigoRetorno($codigoRetorno = null)
    {
        // validation for constraint: int
        if (!is_null($codigoRetorno) && !is_numeric($codigoRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($codigoRetorno)), __LINE__);
        }
        $this->codigoRetorno = $codigoRetorno;
        return $this;
    }
    /**
     * Get mensajeRetorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMensajeRetorno()
    {
        return isset($this->mensajeRetorno) ? $this->mensajeRetorno : null;
    }
    /**
     * Set mensajeRetorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mensajeRetorno
     * @return \StructType\RetornoAbstract
     */
    public function setMensajeRetorno($mensajeRetorno = null)
    {
        // validation for constraint: string
        if (!is_null($mensajeRetorno) && !is_string($mensajeRetorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mensajeRetorno)), __LINE__);
        }
        if (is_null($mensajeRetorno) || (is_array($mensajeRetorno) && empty($mensajeRetorno))) {
            unset($this->mensajeRetorno);
        } else {
            $this->mensajeRetorno = $mensajeRetorno;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetornoAbstract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
