<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInfo StructType
 * @subpackage Structs
 */
class UserInfo extends AbstractStructBase
{
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The middleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The personnelNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $personnelNumber;
    /**
     * Constructor method for UserInfo
     * @uses UserInfo::setLastName()
     * @uses UserInfo::setName()
     * @uses UserInfo::setMiddleName()
     * @uses UserInfo::setUserName()
     * @uses UserInfo::setPersonnelNumber()
     * @param string $lastName
     * @param string $name
     * @param string $middleName
     * @param string $userName
     * @param string $personnelNumber
     */
    public function __construct($lastName = null, $name = null, $middleName = null, $userName = null, $personnelNumber = null)
    {
        $this
            ->setLastName($lastName)
            ->setName($name)
            ->setMiddleName($middleName)
            ->setUserName($userName)
            ->setPersonnelNumber($personnelNumber);
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\UserInfo
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UserInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\UserInfo
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\UserInfo
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get personnelNumber value
     * @return string|null
     */
    public function getPersonnelNumber()
    {
        return $this->personnelNumber;
    }
    /**
     * Set personnelNumber value
     * @param string $personnelNumber
     * @return \StructType\UserInfo
     */
    public function setPersonnelNumber($personnelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($personnelNumber) && !is_string($personnelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personnelNumber, true), gettype($personnelNumber)), __LINE__);
        }
        $this->personnelNumber = $personnelNumber;
        return $this;
    }
}
