<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubjectInfo StructType
 * @subpackage Structs
 */
class SubjectInfo extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The physical
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PhysicalSubject
     */
    public $physical;
    /**
     * The juridical
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JuridicalSubject
     */
    public $juridical;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParametrList
     */
    public $parameters;
    /**
     * Constructor method for SubjectInfo
     * @uses SubjectInfo::setType()
     * @uses SubjectInfo::setPhysical()
     * @uses SubjectInfo::setJuridical()
     * @uses SubjectInfo::setParameters()
     * @param string $type
     * @param \StructType\PhysicalSubject $physical
     * @param \StructType\JuridicalSubject $juridical
     * @param \StructType\ParametrList $parameters
     */
    public function __construct($type = null, \StructType\PhysicalSubject $physical = null, \StructType\JuridicalSubject $juridical = null, \StructType\ParametrList $parameters = null)
    {
        $this
            ->setType($type)
            ->setPhysical($physical)
            ->setJuridical($juridical)
            ->setParameters($parameters);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\SubjectType::valueIsValid()
     * @uses \EnumType\SubjectType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\SubjectInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubjectType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SubjectType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\SubjectType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get physical value
     * @return \StructType\PhysicalSubject|null
     */
    public function getPhysical()
    {
        return $this->physical;
    }
    /**
     * Set physical value
     * @param \StructType\PhysicalSubject $physical
     * @return \StructType\SubjectInfo
     */
    public function setPhysical(\StructType\PhysicalSubject $physical = null)
    {
        $this->physical = $physical;
        return $this;
    }
    /**
     * Get juridical value
     * @return \StructType\JuridicalSubject|null
     */
    public function getJuridical()
    {
        return $this->juridical;
    }
    /**
     * Set juridical value
     * @param \StructType\JuridicalSubject $juridical
     * @return \StructType\SubjectInfo
     */
    public function setJuridical(\StructType\JuridicalSubject $juridical = null)
    {
        $this->juridical = $juridical;
        return $this;
    }
    /**
     * Get parameters value
     * @return \StructType\ParametrList|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \StructType\ParametrList $parameters
     * @return \StructType\SubjectInfo
     */
    public function setParameters(\StructType\ParametrList $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
}
