<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SourcesOfIncome StructType
 * @subpackage Structs
 */
class SourcesOfIncome extends AbstractStructBase
{
    /**
     * The source
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DirectoryElemStrInfo[]
     */
    public $source;
    /**
     * Constructor method for SourcesOfIncome
     * @uses SourcesOfIncome::setSource()
     * @param \StructType\DirectoryElemStrInfo[] $source
     */
    public function __construct(array $source = array())
    {
        $this
            ->setSource($source);
    }
    /**
     * Get source value
     * @return \StructType\DirectoryElemStrInfo[]|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * This method is responsible for validating the values passed to the setSource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSourceForArrayConstraintsFromSetSource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sourcesOfIncomeSourceItem) {
            // validation for constraint: itemType
            if (!$sourcesOfIncomeSourceItem instanceof \StructType\DirectoryElemStrInfo) {
                $invalidValues[] = is_object($sourcesOfIncomeSourceItem) ? get_class($sourcesOfIncomeSourceItem) : sprintf('%s(%s)', gettype($sourcesOfIncomeSourceItem), var_export($sourcesOfIncomeSourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The source property can only contain items of type \StructType\DirectoryElemStrInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set source value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectoryElemStrInfo[] $source
     * @return \StructType\SourcesOfIncome
     */
    public function setSource(array $source = array())
    {
        // validation for constraint: array
        if ('' !== ($sourceArrayErrorMessage = self::validateSourceForArrayConstraintsFromSetSource($source))) {
            throw new \InvalidArgumentException($sourceArrayErrorMessage, __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Add item to source value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectoryElemStrInfo $item
     * @return \StructType\SourcesOfIncome
     */
    public function addToSource(\StructType\DirectoryElemStrInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DirectoryElemStrInfo) {
            throw new \InvalidArgumentException(sprintf('The source property can only contain items of type \StructType\DirectoryElemStrInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->source[] = $item;
        return $this;
    }
}
