<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchPoliciesResponse StructType
 * @subpackage Structs
 */
class SearchPoliciesResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policyShortInfoList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PolicyShortInfoList
     */
    public $policyShortInfoList;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorList
     */
    public $errors;
    /**
     * Constructor method for SearchPoliciesResponse
     * @uses SearchPoliciesResponse::setAccID()
     * @uses SearchPoliciesResponse::setPolicyShortInfoList()
     * @uses SearchPoliciesResponse::setErrors()
     * @param string $accID
     * @param \StructType\PolicyShortInfoList $policyShortInfoList
     * @param \StructType\ErrorList $errors
     */
    public function __construct($accID = null, \StructType\PolicyShortInfoList $policyShortInfoList = null, \StructType\ErrorList $errors = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicyShortInfoList($policyShortInfoList)
            ->setErrors($errors);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\SearchPoliciesResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policyShortInfoList value
     * @return \StructType\PolicyShortInfoList|null
     */
    public function getPolicyShortInfoList()
    {
        return $this->policyShortInfoList;
    }
    /**
     * Set policyShortInfoList value
     * @param \StructType\PolicyShortInfoList $policyShortInfoList
     * @return \StructType\SearchPoliciesResponse
     */
    public function setPolicyShortInfoList(\StructType\PolicyShortInfoList $policyShortInfoList = null)
    {
        $this->policyShortInfoList = $policyShortInfoList;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorList $errors
     * @return \StructType\SearchPoliciesResponse
     */
    public function setErrors(\StructType\ErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
}
