<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiskInfoList StructType
 * @subpackage Structs
 */
class RiskInfoList extends AbstractStructBase
{
    /**
     * The risk
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RiskInfo[]
     */
    public $risk;
    /**
     * Constructor method for RiskInfoList
     * @uses RiskInfoList::setRisk()
     * @param \StructType\RiskInfo[] $risk
     */
    public function __construct(array $risk = array())
    {
        $this
            ->setRisk($risk);
    }
    /**
     * Get risk value
     * @return \StructType\RiskInfo[]|null
     */
    public function getRisk()
    {
        return $this->risk;
    }
    /**
     * This method is responsible for validating the values passed to the setRisk method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRisk method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRiskForArrayConstraintsFromSetRisk(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $riskInfoListRiskItem) {
            // validation for constraint: itemType
            if (!$riskInfoListRiskItem instanceof \StructType\RiskInfo) {
                $invalidValues[] = is_object($riskInfoListRiskItem) ? get_class($riskInfoListRiskItem) : sprintf('%s(%s)', gettype($riskInfoListRiskItem), var_export($riskInfoListRiskItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The risk property can only contain items of type \StructType\RiskInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set risk value
     * @throws \InvalidArgumentException
     * @param \StructType\RiskInfo[] $risk
     * @return \StructType\RiskInfoList
     */
    public function setRisk(array $risk = array())
    {
        // validation for constraint: array
        if ('' !== ($riskArrayErrorMessage = self::validateRiskForArrayConstraintsFromSetRisk($risk))) {
            throw new \InvalidArgumentException($riskArrayErrorMessage, __LINE__);
        }
        $this->risk = $risk;
        return $this;
    }
    /**
     * Add item to risk value
     * @throws \InvalidArgumentException
     * @param \StructType\RiskInfo $item
     * @return \StructType\RiskInfoList
     */
    public function addToRisk(\StructType\RiskInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RiskInfo) {
            throw new \InvalidArgumentException(sprintf('The risk property can only contain items of type \StructType\RiskInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->risk[] = $item;
        return $this;
    }
}
