<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReasonsForReplacementList StructType
 * @subpackage Structs
 */
class ReasonsForReplacementList extends AbstractStructBase
{
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $reason;
    /**
     * Constructor method for ReasonsForReplacementList
     * @uses ReasonsForReplacementList::setReason()
     * @param string[] $reason
     */
    public function __construct(array $reason = array())
    {
        $this
            ->setReason($reason);
    }
    /**
     * Get reason value
     * @return string[]|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * This method is responsible for validating the values passed to the setReason method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReason method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReasonForArrayConstraintsFromSetReason(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reasonsForReplacementListReasonItem) {
            // validation for constraint: itemType
            if (!is_string($reasonsForReplacementListReasonItem)) {
                $invalidValues[] = is_object($reasonsForReplacementListReasonItem) ? get_class($reasonsForReplacementListReasonItem) : sprintf('%s(%s)', gettype($reasonsForReplacementListReasonItem), var_export($reasonsForReplacementListReasonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The reason property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set reason value
     * @throws \InvalidArgumentException
     * @param string[] $reason
     * @return \StructType\ReasonsForReplacementList
     */
    public function setReason(array $reason = array())
    {
        // validation for constraint: array
        if ('' !== ($reasonArrayErrorMessage = self::validateReasonForArrayConstraintsFromSetReason($reason))) {
            throw new \InvalidArgumentException($reasonArrayErrorMessage, __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Add item to reason value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ReasonsForReplacementList
     */
    public function addToReason($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The reason property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->reason[] = $item;
        return $this;
    }
}
