<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDocument StructType
 * @subpackage Structs
 */
class PaymentDocument extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The noncashPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $noncashPayment;
    /**
     * The serial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serial;
    /**
     * Constructor method for PaymentDocument
     * @uses PaymentDocument::setType()
     * @uses PaymentDocument::setNumber()
     * @uses PaymentDocument::setDate()
     * @uses PaymentDocument::setNoncashPayment()
     * @uses PaymentDocument::setSerial()
     * @param string $type
     * @param string $number
     * @param string $date
     * @param bool $noncashPayment
     * @param string $serial
     */
    public function __construct($type = null, $number = null, $date = null, $noncashPayment = null, $serial = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setDate($date)
            ->setNoncashPayment($noncashPayment)
            ->setSerial($serial);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\PaymentDocumentType::valueIsValid()
     * @uses \EnumType\PaymentDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PaymentDocument
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentDocumentType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PaymentDocumentType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\PaymentDocumentType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\PaymentDocument
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\PaymentDocument
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get noncashPayment value
     * @return bool|null
     */
    public function getNoncashPayment()
    {
        return $this->noncashPayment;
    }
    /**
     * Set noncashPayment value
     * @param bool $noncashPayment
     * @return \StructType\PaymentDocument
     */
    public function setNoncashPayment($noncashPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($noncashPayment) && !is_bool($noncashPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noncashPayment, true), gettype($noncashPayment)), __LINE__);
        }
        $this->noncashPayment = $noncashPayment;
        return $this;
    }
    /**
     * Get serial value
     * @return string|null
     */
    public function getSerial()
    {
        return $this->serial;
    }
    /**
     * Set serial value
     * @param string $serial
     * @return \StructType\PaymentDocument
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: string
        if (!is_null($serial) && !is_string($serial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serial, true), gettype($serial)), __LINE__);
        }
        $this->serial = $serial;
        return $this;
    }
}
