<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametrInfo StructType
 * @subpackage Structs
 */
class ParametrInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The stringValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $stringValue;
    /**
     * The intValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $intValue;
    /**
     * The decimalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $decimalValue;
    /**
     * The dateValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateValue;
    /**
     * The boolValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $boolValue;
    /**
     * Constructor method for ParametrInfo
     * @uses ParametrInfo::setName()
     * @uses ParametrInfo::setCode()
     * @uses ParametrInfo::setType()
     * @uses ParametrInfo::setStringValue()
     * @uses ParametrInfo::setIntValue()
     * @uses ParametrInfo::setDecimalValue()
     * @uses ParametrInfo::setDateValue()
     * @uses ParametrInfo::setBoolValue()
     * @param string $name
     * @param string $code
     * @param string $type
     * @param string $stringValue
     * @param int $intValue
     * @param float $decimalValue
     * @param string $dateValue
     * @param bool $boolValue
     */
    public function __construct($name = null, $code = null, $type = null, $stringValue = null, $intValue = null, $decimalValue = null, $dateValue = null, $boolValue = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setType($type)
            ->setStringValue($stringValue)
            ->setIntValue($intValue)
            ->setDecimalValue($decimalValue)
            ->setDateValue($dateValue)
            ->setBoolValue($boolValue);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ParametrInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\ParametrInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ParametrInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get stringValue value
     * @return string|null
     */
    public function getStringValue()
    {
        return $this->stringValue;
    }
    /**
     * Set stringValue value
     * @param string $stringValue
     * @return \StructType\ParametrInfo
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringValue, true), gettype($stringValue)), __LINE__);
        }
        $this->stringValue = $stringValue;
        return $this;
    }
    /**
     * Get intValue value
     * @return int|null
     */
    public function getIntValue()
    {
        return $this->intValue;
    }
    /**
     * Set intValue value
     * @param int $intValue
     * @return \StructType\ParametrInfo
     */
    public function setIntValue($intValue = null)
    {
        // validation for constraint: int
        if (!is_null($intValue) && !(is_int($intValue) || ctype_digit($intValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intValue, true), gettype($intValue)), __LINE__);
        }
        $this->intValue = $intValue;
        return $this;
    }
    /**
     * Get decimalValue value
     * @return float|null
     */
    public function getDecimalValue()
    {
        return $this->decimalValue;
    }
    /**
     * Set decimalValue value
     * @param float $decimalValue
     * @return \StructType\ParametrInfo
     */
    public function setDecimalValue($decimalValue = null)
    {
        // validation for constraint: float
        if (!is_null($decimalValue) && !(is_float($decimalValue) || is_numeric($decimalValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($decimalValue, true), gettype($decimalValue)), __LINE__);
        }
        $this->decimalValue = $decimalValue;
        return $this;
    }
    /**
     * Get dateValue value
     * @return string|null
     */
    public function getDateValue()
    {
        return $this->dateValue;
    }
    /**
     * Set dateValue value
     * @param string $dateValue
     * @return \StructType\ParametrInfo
     */
    public function setDateValue($dateValue = null)
    {
        // validation for constraint: string
        if (!is_null($dateValue) && !is_string($dateValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateValue, true), gettype($dateValue)), __LINE__);
        }
        $this->dateValue = $dateValue;
        return $this;
    }
    /**
     * Get boolValue value
     * @return bool|null
     */
    public function getBoolValue()
    {
        return $this->boolValue;
    }
    /**
     * Set boolValue value
     * @param bool $boolValue
     * @return \StructType\ParametrInfo
     */
    public function setBoolValue($boolValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolValue) && !is_bool($boolValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boolValue, true), gettype($boolValue)), __LINE__);
        }
        $this->boolValue = $boolValue;
        return $this;
    }
}
