<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterDictionaryTypeInfo StructType
 * Meta information extracted from the WSDL
 * - type: tns:ParameterDictionaryTypeInfo
 * @subpackage Structs
 */
class ParameterDictionaryTypeInfo extends AbstractStructBase
{
    /**
     * The DictionaryTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DictionaryTypeCode;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The CalcCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CalcListCodes
     */
    public $CalcCodes;
    /**
     * Constructor method for ParameterDictionaryTypeInfo
     * @uses ParameterDictionaryTypeInfo::setDictionaryTypeCode()
     * @uses ParameterDictionaryTypeInfo::setCode()
     * @uses ParameterDictionaryTypeInfo::setName()
     * @uses ParameterDictionaryTypeInfo::setType()
     * @uses ParameterDictionaryTypeInfo::setCalcCodes()
     * @param string $dictionaryTypeCode
     * @param string $code
     * @param string $name
     * @param string $type
     * @param \StructType\CalcListCodes $calcCodes
     */
    public function __construct($dictionaryTypeCode = null, $code = null, $name = null, $type = null, \StructType\CalcListCodes $calcCodes = null)
    {
        $this
            ->setDictionaryTypeCode($dictionaryTypeCode)
            ->setCode($code)
            ->setName($name)
            ->setType($type)
            ->setCalcCodes($calcCodes);
    }
    /**
     * Get DictionaryTypeCode value
     * @return string|null
     */
    public function getDictionaryTypeCode()
    {
        return $this->DictionaryTypeCode;
    }
    /**
     * Set DictionaryTypeCode value
     * @param string $dictionaryTypeCode
     * @return \StructType\ParameterDictionaryTypeInfo
     */
    public function setDictionaryTypeCode($dictionaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($dictionaryTypeCode) && !is_string($dictionaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictionaryTypeCode, true), gettype($dictionaryTypeCode)), __LINE__);
        }
        $this->DictionaryTypeCode = $dictionaryTypeCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ParameterDictionaryTypeInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ParameterDictionaryTypeInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\ParameterDictionaryTypeInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CalcCodes value
     * @return \StructType\CalcListCodes|null
     */
    public function getCalcCodes()
    {
        return $this->CalcCodes;
    }
    /**
     * Set CalcCodes value
     * @param \StructType\CalcListCodes $calcCodes
     * @return \StructType\ParameterDictionaryTypeInfo
     */
    public function setCalcCodes(\StructType\CalcListCodes $calcCodes = null)
    {
        $this->CalcCodes = $calcCodes;
        return $this;
    }
}
