<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterDictionaryInfo StructType
 * Meta information extracted from the WSDL
 * - type: tns:ParameterDictionaryInfo
 * @subpackage Structs
 */
class ParameterDictionaryInfo extends AbstractStructBase
{
    /**
     * The DictionaryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DictionaryCode;
    /**
     * The ParameterCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ParameterCode;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for ParameterDictionaryInfo
     * @uses ParameterDictionaryInfo::setDictionaryCode()
     * @uses ParameterDictionaryInfo::setParameterCode()
     * @uses ParameterDictionaryInfo::setValue()
     * @param string $dictionaryCode
     * @param string $parameterCode
     * @param string $value
     */
    public function __construct($dictionaryCode = null, $parameterCode = null, $value = null)
    {
        $this
            ->setDictionaryCode($dictionaryCode)
            ->setParameterCode($parameterCode)
            ->setValue($value);
    }
    /**
     * Get DictionaryCode value
     * @return string|null
     */
    public function getDictionaryCode()
    {
        return $this->DictionaryCode;
    }
    /**
     * Set DictionaryCode value
     * @param string $dictionaryCode
     * @return \StructType\ParameterDictionaryInfo
     */
    public function setDictionaryCode($dictionaryCode = null)
    {
        // validation for constraint: string
        if (!is_null($dictionaryCode) && !is_string($dictionaryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictionaryCode, true), gettype($dictionaryCode)), __LINE__);
        }
        $this->DictionaryCode = $dictionaryCode;
        return $this;
    }
    /**
     * Get ParameterCode value
     * @return string|null
     */
    public function getParameterCode()
    {
        return $this->ParameterCode;
    }
    /**
     * Set ParameterCode value
     * @param string $parameterCode
     * @return \StructType\ParameterDictionaryInfo
     */
    public function setParameterCode($parameterCode = null)
    {
        // validation for constraint: string
        if (!is_null($parameterCode) && !is_string($parameterCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterCode, true), gettype($parameterCode)), __LINE__);
        }
        $this->ParameterCode = $parameterCode;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\ParameterDictionaryInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
