<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPaymentURLResponse StructType
 * @subpackage Structs
 */
class GetPaymentURLResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The isError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isError;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorWithCodeList
     */
    public $errors;
    /**
     * Constructor method for GetPaymentURLResponse
     * @uses GetPaymentURLResponse::setAccID()
     * @uses GetPaymentURLResponse::setPolicyID()
     * @uses GetPaymentURLResponse::setUrl()
     * @uses GetPaymentURLResponse::setIsError()
     * @uses GetPaymentURLResponse::setErrors()
     * @param string $accID
     * @param string $policyID
     * @param string $url
     * @param bool $isError
     * @param \StructType\ErrorWithCodeList $errors
     */
    public function __construct($accID = null, $policyID = null, $url = null, $isError = null, \StructType\ErrorWithCodeList $errors = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicyID($policyID)
            ->setUrl($url)
            ->setIsError($isError)
            ->setErrors($errors);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\GetPaymentURLResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\GetPaymentURLResponse
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\GetPaymentURLResponse
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get isError value
     * @return bool|null
     */
    public function getIsError()
    {
        return $this->isError;
    }
    /**
     * Set isError value
     * @param bool $isError
     * @return \StructType\GetPaymentURLResponse
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        $this->isError = $isError;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorWithCodeList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorWithCodeList $errors
     * @return \StructType\GetPaymentURLResponse
     */
    public function setErrors(\StructType\ErrorWithCodeList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
}
