<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetIssueProcessStatusResponse StructType
 * @subpackage Structs
 */
class GetIssueProcessStatusResponse extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The policyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policyID;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The isError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isError;
    /**
     * The errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorWithCodeList
     */
    public $errors;
    /**
     * The processErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorWithCodeList
     */
    public $processErrors;
    /**
     * Constructor method for GetIssueProcessStatusResponse
     * @uses GetIssueProcessStatusResponse::setAccID()
     * @uses GetIssueProcessStatusResponse::setPolicyID()
     * @uses GetIssueProcessStatusResponse::setState()
     * @uses GetIssueProcessStatusResponse::setIsError()
     * @uses GetIssueProcessStatusResponse::setErrors()
     * @uses GetIssueProcessStatusResponse::setProcessErrors()
     * @param string $accID
     * @param string $policyID
     * @param string $state
     * @param bool $isError
     * @param \StructType\ErrorWithCodeList $errors
     * @param \StructType\ErrorWithCodeList $processErrors
     */
    public function __construct($accID = null, $policyID = null, $state = null, $isError = null, \StructType\ErrorWithCodeList $errors = null, \StructType\ErrorWithCodeList $processErrors = null)
    {
        $this
            ->setAccID($accID)
            ->setPolicyID($policyID)
            ->setState($state)
            ->setIsError($isError)
            ->setErrors($errors)
            ->setProcessErrors($processErrors);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\GetIssueProcessStatusResponse
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get policyID value
     * @return string|null
     */
    public function getPolicyID()
    {
        return $this->policyID;
    }
    /**
     * Set policyID value
     * @param string $policyID
     * @return \StructType\GetIssueProcessStatusResponse
     */
    public function setPolicyID($policyID = null)
    {
        // validation for constraint: string
        if (!is_null($policyID) && !is_string($policyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($policyID, true), gettype($policyID)), __LINE__);
        }
        $this->policyID = $policyID;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \EnumType\IssueProcessState::valueIsValid()
     * @uses \EnumType\IssueProcessState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\GetIssueProcessStatusResponse
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IssueProcessState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IssueProcessState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \EnumType\IssueProcessState::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get isError value
     * @return bool|null
     */
    public function getIsError()
    {
        return $this->isError;
    }
    /**
     * Set isError value
     * @param bool $isError
     * @return \StructType\GetIssueProcessStatusResponse
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isError, true), gettype($isError)), __LINE__);
        }
        $this->isError = $isError;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\ErrorWithCodeList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\ErrorWithCodeList $errors
     * @return \StructType\GetIssueProcessStatusResponse
     */
    public function setErrors(\StructType\ErrorWithCodeList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Get processErrors value
     * @return \StructType\ErrorWithCodeList|null
     */
    public function getProcessErrors()
    {
        return $this->processErrors;
    }
    /**
     * Set processErrors value
     * @param \StructType\ErrorWithCodeList $processErrors
     * @return \StructType\GetIssueProcessStatusResponse
     */
    public function setProcessErrors(\StructType\ErrorWithCodeList $processErrors = null)
    {
        $this->processErrors = $processErrors;
        return $this;
    }
}
