<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getDictionaries StructType
 * Meta information extracted from the WSDL
 * - type: tns:getDictionaries
 * @subpackage Structs
 */
class GetDictionaries extends AbstractStructBase
{
    /**
     * The accID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accID;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The dictionaryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dictionaryCode;
    /**
     * The dictionaryConstraint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DictionaryConstraint
     */
    public $dictionaryConstraint;
    /**
     * Constructor method for getDictionaries
     * @uses GetDictionaries::setAccID()
     * @uses GetDictionaries::setProduct()
     * @uses GetDictionaries::setDictionaryCode()
     * @uses GetDictionaries::setDictionaryConstraint()
     * @param string $accID
     * @param string $product
     * @param string $dictionaryCode
     * @param \StructType\DictionaryConstraint $dictionaryConstraint
     */
    public function __construct($accID = null, $product = null, $dictionaryCode = null, \StructType\DictionaryConstraint $dictionaryConstraint = null)
    {
        $this
            ->setAccID($accID)
            ->setProduct($product)
            ->setDictionaryCode($dictionaryCode)
            ->setDictionaryConstraint($dictionaryConstraint);
    }
    /**
     * Get accID value
     * @return string|null
     */
    public function getAccID()
    {
        return $this->accID;
    }
    /**
     * Set accID value
     * @param string $accID
     * @return \StructType\GetDictionaries
     */
    public function setAccID($accID = null)
    {
        // validation for constraint: string
        if (!is_null($accID) && !is_string($accID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accID, true), gettype($accID)), __LINE__);
        }
        $this->accID = $accID;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \StructType\GetDictionaries
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product, true), gettype($product)), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get dictionaryCode value
     * @return string|null
     */
    public function getDictionaryCode()
    {
        return $this->dictionaryCode;
    }
    /**
     * Set dictionaryCode value
     * @param string $dictionaryCode
     * @return \StructType\GetDictionaries
     */
    public function setDictionaryCode($dictionaryCode = null)
    {
        // validation for constraint: string
        if (!is_null($dictionaryCode) && !is_string($dictionaryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dictionaryCode, true), gettype($dictionaryCode)), __LINE__);
        }
        $this->dictionaryCode = $dictionaryCode;
        return $this;
    }
    /**
     * Get dictionaryConstraint value
     * @return \StructType\DictionaryConstraint|null
     */
    public function getDictionaryConstraint()
    {
        return $this->dictionaryConstraint;
    }
    /**
     * Set dictionaryConstraint value
     * @param \StructType\DictionaryConstraint $dictionaryConstraint
     * @return \StructType\GetDictionaries
     */
    public function setDictionaryConstraint(\StructType\DictionaryConstraint $dictionaryConstraint = null)
    {
        $this->dictionaryConstraint = $dictionaryConstraint;
        return $this;
    }
}
