<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorWithCode StructType
 * @subpackage Structs
 */
class ErrorWithCode extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $code;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The detailMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $detailMessage;
    /**
     * Constructor method for ErrorWithCode
     * @uses ErrorWithCode::setCode()
     * @uses ErrorWithCode::setMessage()
     * @uses ErrorWithCode::setDetailMessage()
     * @param int $code
     * @param string $message
     * @param string $detailMessage
     */
    public function __construct($code = null, $message = null, $detailMessage = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setDetailMessage($detailMessage);
    }
    /**
     * Get code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\ErrorWithCode
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ErrorWithCode
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get detailMessage value
     * @return string|null
     */
    public function getDetailMessage()
    {
        return $this->detailMessage;
    }
    /**
     * Set detailMessage value
     * @param string $detailMessage
     * @return \StructType\ErrorWithCode
     */
    public function setDetailMessage($detailMessage = null)
    {
        // validation for constraint: string
        if (!is_null($detailMessage) && !is_string($detailMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailMessage, true), gettype($detailMessage)), __LINE__);
        }
        $this->detailMessage = $detailMessage;
        return $this;
    }
}
