<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DictionaryConstraint StructType
 * @subpackage Structs
 */
class DictionaryConstraint extends AbstractStructBase
{
    /**
     * The Constraint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Constraint[]
     */
    public $Constraint;
    /**
     * Constructor method for DictionaryConstraint
     * @uses DictionaryConstraint::setConstraint()
     * @param \StructType\Constraint[] $constraint
     */
    public function __construct(array $constraint = array())
    {
        $this
            ->setConstraint($constraint);
    }
    /**
     * Get Constraint value
     * @return \StructType\Constraint[]|null
     */
    public function getConstraint()
    {
        return $this->Constraint;
    }
    /**
     * This method is responsible for validating the values passed to the setConstraint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConstraint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConstraintForArrayConstraintsFromSetConstraint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dictionaryConstraintConstraintItem) {
            // validation for constraint: itemType
            if (!$dictionaryConstraintConstraintItem instanceof \StructType\Constraint) {
                $invalidValues[] = is_object($dictionaryConstraintConstraintItem) ? get_class($dictionaryConstraintConstraintItem) : sprintf('%s(%s)', gettype($dictionaryConstraintConstraintItem), var_export($dictionaryConstraintConstraintItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Constraint property can only contain items of type \StructType\Constraint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Constraint value
     * @throws \InvalidArgumentException
     * @param \StructType\Constraint[] $constraint
     * @return \StructType\DictionaryConstraint
     */
    public function setConstraint(array $constraint = array())
    {
        // validation for constraint: array
        if ('' !== ($constraintArrayErrorMessage = self::validateConstraintForArrayConstraintsFromSetConstraint($constraint))) {
            throw new \InvalidArgumentException($constraintArrayErrorMessage, __LINE__);
        }
        $this->Constraint = $constraint;
        return $this;
    }
    /**
     * Add item to Constraint value
     * @throws \InvalidArgumentException
     * @param \StructType\Constraint $item
     * @return \StructType\DictionaryConstraint
     */
    public function addToConstraint(\StructType\Constraint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Constraint) {
            throw new \InvalidArgumentException(sprintf('The Constraint property can only contain items of type \StructType\Constraint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Constraint[] = $item;
        return $this;
    }
}
