<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cross StructType
 * Meta information extracted from the WSDL
 * - type: tns:Cross
 * @subpackage Structs
 */
class Cross extends AbstractStructBase
{
    /**
     * The internalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $internalID;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * Constructor method for Cross
     * @uses Cross::setInternalID()
     * @uses Cross::setNumber()
     * @param int $internalID
     * @param string $number
     */
    public function __construct($internalID = null, $number = null)
    {
        $this
            ->setInternalID($internalID)
            ->setNumber($number);
    }
    /**
     * Get internalID value
     * @return int|null
     */
    public function getInternalID()
    {
        return $this->internalID;
    }
    /**
     * Set internalID value
     * @param int $internalID
     * @return \StructType\Cross
     */
    public function setInternalID($internalID = null)
    {
        // validation for constraint: int
        if (!is_null($internalID) && !(is_int($internalID) || ctype_digit($internalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalID, true), gettype($internalID)), __LINE__);
        }
        $this->internalID = $internalID;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\Cross
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
}
