<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactPersontList StructType
 * @subpackage Structs
 */
class ContactPersontList extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactPerson[]
     */
    public $contact;
    /**
     * Constructor method for ContactPersontList
     * @uses ContactPersontList::setContact()
     * @param \StructType\ContactPerson[] $contact
     */
    public function __construct(array $contact = array())
    {
        $this
            ->setContact($contact);
    }
    /**
     * Get contact value
     * @return \StructType\ContactPerson[]|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * This method is responsible for validating the values passed to the setContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactForArrayConstraintsFromSetContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactPersontListContactItem) {
            // validation for constraint: itemType
            if (!$contactPersontListContactItem instanceof \StructType\ContactPerson) {
                $invalidValues[] = is_object($contactPersontListContactItem) ? get_class($contactPersontListContactItem) : sprintf('%s(%s)', gettype($contactPersontListContactItem), var_export($contactPersontListContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The contact property can only contain items of type \StructType\ContactPerson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set contact value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPerson[] $contact
     * @return \StructType\ContactPersontList
     */
    public function setContact(array $contact = array())
    {
        // validation for constraint: array
        if ('' !== ($contactArrayErrorMessage = self::validateContactForArrayConstraintsFromSetContact($contact))) {
            throw new \InvalidArgumentException($contactArrayErrorMessage, __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Add item to contact value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPerson $item
     * @return \StructType\ContactPersontList
     */
    public function addToContact(\StructType\ContactPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactPerson) {
            throw new \InvalidArgumentException(sprintf('The contact property can only contain items of type \StructType\ContactPerson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->contact[] = $item;
        return $this;
    }
}
