<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConstitutorListInfo StructType
 * @subpackage Structs
 */
class ConstitutorListInfo extends AbstractStructBase
{
    /**
     * The constitutors
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UchreditelInfo[]
     */
    public $constitutors;
    /**
     * Constructor method for ConstitutorListInfo
     * @uses ConstitutorListInfo::setConstitutors()
     * @param \StructType\UchreditelInfo[] $constitutors
     */
    public function __construct(array $constitutors = array())
    {
        $this
            ->setConstitutors($constitutors);
    }
    /**
     * Get constitutors value
     * @return \StructType\UchreditelInfo[]|null
     */
    public function getConstitutors()
    {
        return $this->constitutors;
    }
    /**
     * This method is responsible for validating the values passed to the setConstitutors method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConstitutors method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConstitutorsForArrayConstraintsFromSetConstitutors(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $constitutorListInfoConstitutorsItem) {
            // validation for constraint: itemType
            if (!$constitutorListInfoConstitutorsItem instanceof \StructType\UchreditelInfo) {
                $invalidValues[] = is_object($constitutorListInfoConstitutorsItem) ? get_class($constitutorListInfoConstitutorsItem) : sprintf('%s(%s)', gettype($constitutorListInfoConstitutorsItem), var_export($constitutorListInfoConstitutorsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The constitutors property can only contain items of type \StructType\UchreditelInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set constitutors value
     * @throws \InvalidArgumentException
     * @param \StructType\UchreditelInfo[] $constitutors
     * @return \StructType\ConstitutorListInfo
     */
    public function setConstitutors(array $constitutors = array())
    {
        // validation for constraint: array
        if ('' !== ($constitutorsArrayErrorMessage = self::validateConstitutorsForArrayConstraintsFromSetConstitutors($constitutors))) {
            throw new \InvalidArgumentException($constitutorsArrayErrorMessage, __LINE__);
        }
        $this->constitutors = $constitutors;
        return $this;
    }
    /**
     * Add item to constitutors value
     * @throws \InvalidArgumentException
     * @param \StructType\UchreditelInfo $item
     * @return \StructType\ConstitutorListInfo
     */
    public function addToConstitutors(\StructType\UchreditelInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UchreditelInfo) {
            throw new \InvalidArgumentException(sprintf('The constitutors property can only contain items of type \StructType\UchreditelInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->constitutors[] = $item;
        return $this;
    }
}
