<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlankEntry StructType
 * @subpackage Structs
 */
class BlankEntry extends AbstractStructBase
{
    /**
     * The rol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rol;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The seria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seria;
    /**
     * Constructor method for BlankEntry
     * @uses BlankEntry::setRol()
     * @uses BlankEntry::setNumber()
     * @uses BlankEntry::setSeria()
     * @param string $rol
     * @param string $number
     * @param string $seria
     */
    public function __construct($rol = null, $number = null, $seria = null)
    {
        $this
            ->setRol($rol)
            ->setNumber($number)
            ->setSeria($seria);
    }
    /**
     * Get rol value
     * @return string|null
     */
    public function getRol()
    {
        return $this->rol;
    }
    /**
     * Set rol value
     * @uses \EnumType\BlankRole::valueIsValid()
     * @uses \EnumType\BlankRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rol
     * @return \StructType\BlankEntry
     */
    public function setRol($rol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BlankRole::valueIsValid($rol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BlankRole', is_array($rol) ? implode(', ', $rol) : var_export($rol, true), implode(', ', \EnumType\BlankRole::getValidValues())), __LINE__);
        }
        $this->rol = $rol;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\BlankEntry
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get seria value
     * @return string|null
     */
    public function getSeria()
    {
        return $this->seria;
    }
    /**
     * Set seria value
     * @param string $seria
     * @return \StructType\BlankEntry
     */
    public function setSeria($seria = null)
    {
        // validation for constraint: string
        if (!is_null($seria) && !is_string($seria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seria, true), gettype($seria)), __LINE__);
        }
        $this->seria = $seria;
        return $this;
    }
}
